/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.ClassUtils;

public abstract class LoggingSystem {
    private static final Map<String, String> SYSTEMS;

    public abstract void beforeInitialize();

    public abstract void initialize(String var1, String var2);

    public abstract void setLogLevel(String var1, LogLevel var2);

    public static LoggingSystem get(ClassLoader classLoader) {
        for (Map.Entry<String, String> entry : SYSTEMS.entrySet()) {
            if (!ClassUtils.isPresent((String)entry.getKey(), (ClassLoader)classLoader)) continue;
            try {
                Class systemClass = ClassUtils.forName((String)entry.getValue(), (ClassLoader)classLoader);
                return (LoggingSystem)systemClass.getConstructor(ClassLoader.class).newInstance(classLoader);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        throw new IllegalStateException("No suitable logging system located");
    }

    static {
        LinkedHashMap<String, String> systems = new LinkedHashMap<String, String>();
        systems.put("ch.qos.logback.core.Appender", "org.springframework.boot.logging.logback.LogbackLoggingSystem");
        systems.put("org.apache.log4j.PropertyConfigurator", "org.springframework.boot.logging.log4j.Log4JLoggingSystem");
        systems.put("org.apache.logging.log4j.LogManager", "org.springframework.boot.logging.log4j2.Log4J2LoggingSystem");
        systems.put("java.util.logging.LogManager", "org.springframework.boot.logging.java.JavaLoggingSystem");
        SYSTEMS = Collections.unmodifiableMap(systems);
    }
}

