/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.PropertyNamePatternsMatcher;
import org.springframework.boot.bind.SimplePropertyNamePatternsMatcher;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.ReflectionUtils;

public class PropertySourcesPropertyValues
implements PropertyValues {
    private final Map<String, PropertyValue> propertyValues = new ConcurrentHashMap<String, PropertyValue>();
    private final PropertySources propertySources;
    private static final Collection<String> PATTERN_MATCHED_PROPERTY_SOURCES = Arrays.asList("systemEnvironment", "systemProperties");

    public PropertySourcesPropertyValues(PropertySources propertySources) {
        this(propertySources, (PropertyNamePatternsMatcher)null, (Collection<String>)null);
    }

    public PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> includePatterns, Collection<String> names) {
        this(propertySources, new SimplePropertyNamePatternsMatcher(includePatterns), names);
    }

    PropertySourcesPropertyValues(PropertySources propertySources, PropertyNamePatternsMatcher includes, Collection<String> names) {
        this.propertySources = propertySources;
        if (includes == null) {
            includes = PropertyNamePatternsMatcher.NONE;
        }
        if (names == null) {
            names = Collections.emptySet();
        }
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(propertySources);
        for (PropertySource source : propertySources) {
            this.processPropertySource(source, resolver, includes, names);
        }
    }

    private void processPropertySource(PropertySource<?> source, PropertySourcesPropertyResolver resolver, PropertyNamePatternsMatcher includes, Collection<String> exacts) {
        if (source instanceof EnumerablePropertySource) {
            this.processEnumerablePropertySource((EnumerablePropertySource)source, resolver, includes, exacts);
        } else if (source instanceof CompositePropertySource) {
            this.processCompositePropertySource((CompositePropertySource)source, resolver, includes, exacts);
        } else {
            this.processDefaultPropertySource(source, resolver, includes, exacts);
        }
    }

    private void processEnumerablePropertySource(EnumerablePropertySource<?> source, PropertySourcesPropertyResolver resolver, PropertyNamePatternsMatcher includes, Collection<String> exacts) {
        if (source.getPropertyNames().length > 0) {
            for (String propertyName : source.getPropertyNames()) {
                if (PATTERN_MATCHED_PROPERTY_SOURCES.contains(source.getName()) && !includes.matches(propertyName)) continue;
                Object value = source.getProperty(propertyName);
                try {
                    value = resolver.getProperty(propertyName);
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
                if (this.propertyValues.containsKey(propertyName)) continue;
                this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
            }
        }
    }

    private void processCompositePropertySource(CompositePropertySource source, PropertySourcesPropertyResolver resolver, PropertyNamePatternsMatcher includes, Collection<String> exacts) {
        for (PropertySource<?> nested : this.extractSources(source)) {
            this.processPropertySource(nested, resolver, includes, exacts);
        }
    }

    private Collection<PropertySource<?>> extractSources(CompositePropertySource composite) {
        Field field = ReflectionUtils.findField(CompositePropertySource.class, (String)"propertySources");
        field.setAccessible(true);
        try {
            Collection collection = (Collection)field.get(composite);
            return collection;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot extract property sources from composite", ex);
        }
    }

    private void processDefaultPropertySource(PropertySource<?> source, PropertySourcesPropertyResolver resolver, PropertyNamePatternsMatcher includes, Collection<String> exacts) {
        for (String propertyName : exacts) {
            Object value = null;
            try {
                value = resolver.getProperty(propertyName, Object.class);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            if (value == null) {
                value = source.getProperty(propertyName.toUpperCase());
            }
            if (value == null || this.propertyValues.containsKey(propertyName)) continue;
            this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
        }
    }

    public PropertyValue[] getPropertyValues() {
        Collection<PropertyValue> values = this.propertyValues.values();
        return values.toArray(new PropertyValue[values.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        PropertyValue propertyValue = this.propertyValues.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        for (PropertySource source : this.propertySources) {
            Object value = source.getProperty(propertyName);
            if (value == null) continue;
            propertyValue = new PropertyValue(propertyName, value);
            this.propertyValues.put(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        for (PropertyValue newValue : this.getPropertyValues()) {
            PropertyValue oldValue = old.getPropertyValue(newValue.getName());
            if (oldValue != null && oldValue.equals((Object)newValue)) continue;
            changes.addPropertyValue(newValue);
        }
        return changes;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }
}

