/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.web.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.SpringVersion;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringApplicationContextLoader
extends AbstractContextLoader {
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        SpringApplication application = this.getSpringApplication();
        application.setSources(this.getSources(mergedConfig));
        if (!ObjectUtils.isEmpty((Object[])mergedConfig.getActiveProfiles())) {
            application.setAdditionalProfiles(mergedConfig.getActiveProfiles());
        }
        application.setDefaultProperties(this.getArgs(mergedConfig));
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(mergedConfig, application);
        if (mergedConfig instanceof WebMergedContextConfiguration) {
            new WebConfigurer().setup(mergedConfig, application, initializers);
        } else {
            application.setWebEnvironment(false);
        }
        application.setInitializers(initializers);
        return application.run(new String[0]);
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        if (!configAttributes.hasLocations() && !configAttributes.hasClasses()) {
            Class[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected SpringApplication getSpringApplication() {
        return new SpringApplication(new Object[0]);
    }

    private Set<Object> getSources(MergedContextConfiguration mergedConfig) {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        sources.addAll(Arrays.asList(mergedConfig.getClasses()));
        sources.addAll(Arrays.asList(mergedConfig.getLocations()));
        if (sources.isEmpty()) {
            throw new IllegalStateException("No configuration classes or locations found in @SpringApplicationConfiguration. For default configuration detection to work you need Spring 4.0.3 or better (found " + SpringVersion.getVersion() + ").");
        }
        return sources;
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    private Map<String, Object> getArgs(MergedContextConfiguration mergedConfig) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("server.port", "-1");
        args.put("spring.jmx.enabled", "false");
        return args;
    }

    private List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration mergedConfig, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : mergedConfig.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiate((Class)initializerClass));
        }
        return initializers;
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }

    private static class WebConfigurer {
        private WebConfigurer() {
        }

        void setup(MergedContextConfiguration mergedConfig, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfig = (WebMergedContextConfiguration)mergedConfig;
            MockServletContext servletContext = new MockServletContext(webConfig.getResourceBasePath());
            initializers.add(0, new ServletContextApplicationContextInitializer((ServletContext)servletContext));
            application.setApplicationContextClass(GenericWebApplicationContext.class);
        }
    }
}

