/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.initializer.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringApplicationContextLoader
extends AbstractContextLoader {
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        SpringApplication application = new SpringApplication(new Object[0]);
        application.setSources(this.getSources(mergedConfig));
        if (!ObjectUtils.isEmpty((Object[])mergedConfig.getActiveProfiles())) {
            application.setAdditionalProfiles(Arrays.asList(mergedConfig.getActiveProfiles()));
        }
        application.setDefaultProperties(this.getArgs(mergedConfig));
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(mergedConfig, application);
        if (mergedConfig instanceof WebMergedContextConfiguration) {
            new WebConfigurer().setup(mergedConfig, application, initializers);
        } else {
            application.setWebEnvironment(false);
        }
        application.setInitializers(initializers);
        return application.run(new String[0]);
    }

    private Set<Object> getSources(MergedContextConfiguration mergedConfig) {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        sources.addAll(Arrays.asList(mergedConfig.getClasses()));
        sources.addAll(Arrays.asList(mergedConfig.getLocations()));
        return sources;
    }

    private Map<String, Object> getArgs(MergedContextConfiguration mergedConfig) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("server.port", "-1");
        return args;
    }

    private List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration mergedConfig, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : mergedConfig.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiate((Class)initializerClass));
        }
        return initializers;
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }

    private static class WebConfigurer {
        private WebConfigurer() {
        }

        void setup(MergedContextConfiguration mergedConfig, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfig = (WebMergedContextConfiguration)mergedConfig;
            MockServletContext servletContext = new MockServletContext(webConfig.getResourceBasePath());
            initializers.add(0, new ServletContextApplicationContextInitializer((ServletContext)servletContext));
            application.setApplicationContextClass(GenericWebApplicationContext.class);
        }
    }
}

