/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.ClassUtils;

public abstract class LoggingSystem {
    private static final Map<String, String> SYSTEMS;

    public abstract void beforeInitialize();

    public abstract void initialize();

    public abstract void initialize(String var1);

    public abstract void setLogLevel(String var1, LogLevel var2);

    public static LoggingSystem get(ClassLoader classLoader) {
        for (Map.Entry<String, String> entry : SYSTEMS.entrySet()) {
            if (!ClassUtils.isPresent((String)entry.getKey(), (ClassLoader)classLoader)) continue;
            try {
                Class systemClass = ClassUtils.forName((String)entry.getValue(), (ClassLoader)classLoader);
                return (LoggingSystem)systemClass.getConstructor(ClassLoader.class).newInstance(classLoader);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        throw new IllegalStateException("No suitable logging system located");
    }

    static {
        LinkedHashMap<String, String> systems = new LinkedHashMap<String, String>();
        String pkg = LoggingSystem.class.getPackage().getName();
        systems.put("ch.qos.logback.core.Appender", pkg + ".logback.LogbackLoggingSystem");
        systems.put("org.apache.log4j.PropertyConfigurator", pkg + ".log4j.Log4JLoggingSystem");
        systems.put("java.util.logging.LogManager", pkg + ".java.JavaLoggingSystem");
        SYSTEMS = Collections.unmodifiableMap(systems);
    }
}

