/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class ContextIdApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private String name;
    private int index = -1;
    private int order = 0x7FFFFFF5;

    public ContextIdApplicationContextInitializer() {
        this("${spring.application.name:${vcap.application.name:${spring.config.name:application}}}");
    }

    public ContextIdApplicationContextInitializer(String name) {
        this.name = name;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.setId(this.getApplicationId(applicationContext.getEnvironment()));
    }

    private String getApplicationId(ConfigurableEnvironment environment) {
        String name = environment.resolvePlaceholders(this.name);
        int index = (Integer)environment.getProperty("PORT", Integer.class, (Object)this.index);
        index = (Integer)environment.getProperty("vcap.application.instance_index", Integer.class, (Object)index);
        if ((index = ((Integer)environment.getProperty("spring.application.index", Integer.class, (Object)index)).intValue()) >= 0) {
            return name + ":" + index;
        }
        String profiles = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        if (StringUtils.hasText((String)profiles)) {
            name = name + ":" + profiles;
        }
        return name;
    }
}

