/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;

public class RelaxedPropertyResolver
implements PropertyResolver {
    private final PropertyResolver resolver;
    private final String prefix;

    public RelaxedPropertyResolver(PropertyResolver resolver) {
        this(resolver, null);
    }

    public RelaxedPropertyResolver(PropertyResolver resolver, String prefix) {
        Assert.notNull((Object)resolver, (String)"PropertyResolver must not be null");
        this.resolver = resolver;
        this.prefix = prefix == null ? "" : prefix;
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.getRequiredProperty(key, String.class);
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        Assert.state((value != null ? 1 : 0) != 0, (String)String.format("required key [%s] not found", key));
        return value;
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class, null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, String.class, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return this.getProperty(key, targetType, null);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        RelaxedNames prefixes = new RelaxedNames(this.prefix);
        RelaxedNames keys = new RelaxedNames(key);
        for (String prefix : prefixes) {
            for (String relaxedKey : keys) {
                if (!this.resolver.containsProperty(prefix + relaxedKey)) continue;
                return (T)this.resolver.getProperty(prefix + relaxedKey, targetType);
            }
        }
        return defaultValue;
    }

    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        RelaxedNames prefixes = new RelaxedNames(this.prefix);
        RelaxedNames keys = new RelaxedNames(key);
        for (String prefix : prefixes) {
            for (String relaxedKey : keys) {
                if (!this.resolver.containsProperty(prefix + relaxedKey)) continue;
                return this.resolver.getPropertyAsClass(prefix + relaxedKey, targetType);
            }
        }
        return null;
    }

    public boolean containsProperty(String key) {
        RelaxedNames prefixes = new RelaxedNames(this.prefix);
        RelaxedNames keys = new RelaxedNames(key);
        for (String prefix : prefixes) {
            for (String relaxedKey : keys) {
                if (!this.resolver.containsProperty(prefix + relaxedKey)) continue;
                return true;
            }
        }
        return false;
    }

    public String resolvePlaceholders(String text) {
        throw new UnsupportedOperationException("Unable to resolve placeholders with relaxed properties");
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Unable to resolve placeholders with relaxed properties");
    }

    public Map<String, Object> getSubProperties(String keyPrefix) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)this.resolver, (String)"SubProperties not available.");
        ConfigurableEnvironment env = (ConfigurableEnvironment)this.resolver;
        return RelaxedPropertyResolver.getSubProperties((PropertySources)env.getPropertySources(), this.prefix, keyPrefix);
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, String keyPrefix) {
        return RelaxedPropertyResolver.getSubProperties(propertySources, null, keyPrefix);
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, String rootPrefix, String keyPrefix) {
        RelaxedNames keyPrefixes = new RelaxedNames(keyPrefix);
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        for (PropertySource source : propertySources) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                String key = RelaxedPropertyResolver.getSubKey(name, rootPrefix, keyPrefixes);
                if (key == null) continue;
                subProperties.put(key, source.getProperty(name));
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    private static String getSubKey(String name, String rootPrefixes, RelaxedNames keyPrefix) {
        rootPrefixes = rootPrefixes == null ? "" : rootPrefixes;
        for (String rootPrefix : new RelaxedNames(rootPrefixes)) {
            for (String candidateKeyPrefix : keyPrefix) {
                if (!name.startsWith(rootPrefix + candidateKeyPrefix)) continue;
                return name.substring((rootPrefix + candidateKeyPrefix).length());
            }
        }
        return null;
    }
}

