/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webtestclient.autoconfigure;

import java.time.Duration;
import java.util.Collection;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.webtestclient.autoconfigure.WebTestClientBuilderCustomizer;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.ExchangeStrategies;

public class SpringBootWebTestClientBuilderCustomizer
implements WebTestClientBuilderCustomizer {
    private final Collection<CodecCustomizer> codecCustomizers;
    private @Nullable Duration timeout;

    public SpringBootWebTestClientBuilderCustomizer(Collection<CodecCustomizer> codecCustomizers) {
        this.codecCustomizers = codecCustomizers;
    }

    public void setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public void customize(WebTestClient.Builder builder) {
        if (this.timeout != null) {
            builder.responseTimeout(this.timeout);
        }
        this.customizeWebTestClientCodecs(builder);
    }

    private void customizeWebTestClientCodecs(WebTestClient.Builder builder) {
        if (!CollectionUtils.isEmpty(this.codecCustomizers)) {
            builder.exchangeStrategies(ExchangeStrategies.builder().codecs(this.applyCustomizers(this.codecCustomizers)).build());
        }
    }

    private Consumer<ClientCodecConfigurer> applyCustomizers(Collection<CodecCustomizer> customizers) {
        return codecs -> customizers.forEach(customizer -> customizer.customize((CodecConfigurer)codecs));
    }
}

