/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationProperties;
import org.springframework.boot.webclient.observation.ObservationWebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.DefaultClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(beforeName={"org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnClass(value={WebClient.class, ObservationWebClientCustomizer.class, ObservationRegistry.class, ObservationProperties.class})
@EnableConfigurationProperties(value={ObservationProperties.class})
public final class WebClientObservationAutoConfiguration {
    @Bean
    ObservationWebClientCustomizer observationWebClientCustomizer(ObservationRegistry observationRegistry, ObjectProvider<ClientRequestObservationConvention> customConvention, ObservationProperties observationProperties) {
        String name = observationProperties.getHttp().getClient().getRequests().getName();
        ClientRequestObservationConvention observationConvention = (ClientRequestObservationConvention)customConvention.getIfAvailable(() -> new DefaultClientRequestObservationConvention(name));
        return new ObservationWebClientCustomizer(observationRegistry, observationConvention);
    }
}

