/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet;

import java.io.File;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationTemp;
import org.springframework.util.Assert;

public class SessionStoreDirectory {
    private @Nullable File directory;

    @Nullable File getDirectory() {
        return this.directory;
    }

    void setDirectory(@Nullable File directory) {
        this.directory = directory;
    }

    public File getValidDirectory(boolean mkdirs) {
        File dir = this.getDirectory();
        if (dir == null) {
            return new ApplicationTemp().getDir("servlet-sessions");
        }
        if (!dir.isAbsolute()) {
            dir = new File(new ApplicationHome().getDir(), dir.getPath());
        }
        if (!dir.exists() && mkdirs) {
            dir.mkdirs();
        }
        this.assertDirectory(mkdirs, dir);
        return dir;
    }

    private void assertDirectory(boolean mkdirs, File dir) {
        Assert.state((!mkdirs || dir.exists() ? 1 : 0) != 0, () -> "Session dir " + String.valueOf(dir) + " does not exist");
        Assert.state((!dir.isFile() ? 1 : 0) != 0, () -> "Session dir " + String.valueOf(dir) + " points to a file");
    }
}

