/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.autoconfigure.servlet;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.servlet.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.server.servlet.CookieSameSiteSupplier;
import org.springframework.boot.web.server.servlet.WebListenerRegistrar;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class ServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;
    private final List<WebListenerRegistrar> webListenerRegistrars;
    private final List<CookieSameSiteSupplier> cookieSameSiteSuppliers;
    private final @Nullable SslBundles sslBundles;

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this(serverProperties, Collections.emptyList(), Collections.emptyList(), null);
    }

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties, List<WebListenerRegistrar> webListenerRegistrars, List<CookieSameSiteSupplier> cookieSameSiteSuppliers, @Nullable SslBundles sslBundles) {
        this.serverProperties = serverProperties;
        this.webListenerRegistrars = webListenerRegistrars;
        this.cookieSameSiteSuppliers = cookieSameSiteSuppliers;
        this.sslBundles = sslBundles;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableServletWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serverProperties::getPort).to(factory::setPort);
        map.from(this.serverProperties::getAddress).to(factory::setAddress);
        map.from(this.serverProperties.getServlet()::getContextPath).to(factory::setContextPath);
        map.from(this.serverProperties.getServlet()::getApplicationDisplayName).to(factory::setDisplayName);
        map.from(this.serverProperties.getServlet()::isRegisterDefaultServlet).to(factory::setRegisterDefaultServlet);
        map.from(this.serverProperties.getServlet()::getSession).to(factory::setSession);
        map.from(this.serverProperties::getSsl).to(factory::setSsl);
        map.from(this.serverProperties.getServlet()::getJsp).to(factory::setJsp);
        map.from(this.serverProperties::getCompression).to(factory::setCompression);
        map.from(this.serverProperties::getHttp2).to(factory::setHttp2);
        map.from(this.serverProperties::getServerHeader).to(factory::setServerHeader);
        map.from(this.serverProperties.getServlet()::getContextParameters).to(factory::setInitParameters);
        map.from((Object)this.serverProperties.getShutdown()).to(factory::setShutdown);
        map.from(() -> this.sslBundles).to(factory::setSslBundles);
        map.from(() -> this.cookieSameSiteSuppliers).whenNot(CollectionUtils::isEmpty).to(factory::setCookieSameSiteSuppliers);
        map.from(this.serverProperties::getMimeMappings).to(factory::addMimeMappings);
        map.from(this.serverProperties.getServlet().getEncoding()::getMapping).to(factory::setLocaleCharsetMappings);
        this.webListenerRegistrars.forEach(registrar -> registrar.register(factory));
    }
}

