/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.autoconfigure.reactive;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.server.WebServerFactoryCustomizerBeanPostProcessor;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.autoconfigure.reactive.ReactiveWebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.adapter.ForwardedHeaderTransformer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ServerProperties.class})
@Import(value={BeanPostProcessorsRegistrar.class})
public class ReactiveWebServerConfiguration {
    @Bean
    public ReactiveWebServerFactoryCustomizer reactiveWebServerFactoryCustomizer(ServerProperties serverProperties, ObjectProvider<SslBundles> sslBundles) {
        return new ReactiveWebServerFactoryCustomizer(serverProperties, (SslBundles)sslBundles.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"server.forward-headers-strategy"}, havingValue="framework")
    public ForwardedHeaderTransformer forwardedHeaderTransformer() {
        return new ForwardedHeaderTransformer();
    }

    public static class BeanPostProcessorsRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private @Nullable ConfigurableListableBeanFactory beanFactory;

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                ConfigurableListableBeanFactory listableBeanFactory;
                this.beanFactory = listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory == null) {
                return;
            }
            this.registerSyntheticBeanIfMissing(this.beanFactory, registry, "webServerFactoryCustomizerBeanPostProcessor", WebServerFactoryCustomizerBeanPostProcessor.class);
        }

        private <T> void registerSyntheticBeanIfMissing(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, String name, Class<T> beanClass) {
            if (ObjectUtils.isEmpty((Object[])beanFactory.getBeanNamesForType(beanClass, true, false))) {
                RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            }
        }
    }
}

