/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.context;

import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.testcontainers.context.ContainerFieldsImporter;
import org.springframework.boot.testcontainers.context.DynamicPropertySourceMethodsImporter;
import org.springframework.boot.testcontainers.context.ImportTestcontainers;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.testcontainers.lifecycle.Startable;

class ImportTestcontainersRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String DYNAMIC_PROPERTY_SOURCE_CLASS = "org.springframework.test.context.DynamicPropertySource";
    private final ContainerFieldsImporter containerFieldsImporter = new ContainerFieldsImporter();
    private final DynamicPropertySourceMethodsImporter dynamicPropertySourceMethodsImporter = !ClassUtils.isPresent((String)"org.springframework.test.context.DynamicPropertySource", null) ? null : new DynamicPropertySourceMethodsImporter();

    ImportTestcontainersRegistrar(Environment environment) {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        MergedAnnotation annotation = importingClassMetadata.getAnnotations().get(ImportTestcontainers.class);
        Object[] definitionClasses = annotation.getClassArray("value");
        if (ObjectUtils.isEmpty((Object[])definitionClasses)) {
            Class importingClass = ClassUtils.resolveClassName((String)importingClassMetadata.getClassName(), null);
            definitionClasses = new Class[]{importingClass};
        }
        this.registerBeanDefinitions(registry, (Class<?>[])definitionClasses);
    }

    private void registerBeanDefinitions(BeanDefinitionRegistry registry, Class<?>[] definitionClasses) {
        for (Class<?> definitionClass : definitionClasses) {
            Set<Startable> importedContainers = this.containerFieldsImporter.registerBeanDefinitions(registry, definitionClass);
            if (this.dynamicPropertySourceMethodsImporter == null) continue;
            this.dynamicPropertySourceMethodsImporter.registerDynamicPropertySources(registry, definitionClass, importedContainers);
        }
    }
}

