/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.lifecycle.Startable;

public abstract class ContainerConnectionDetailsFactory<C extends Container<?>, D extends ConnectionDetails>
implements ConnectionDetailsFactory<ContainerConnectionSource<C>, D> {
    protected static final String ANY_CONNECTION_NAME = null;
    private final List<String> connectionNames;
    private final String[] requiredClassNames;

    protected ContainerConnectionDetailsFactory() {
        this(ANY_CONNECTION_NAME, new String[0]);
    }

    protected ContainerConnectionDetailsFactory(String connectionName, String ... requiredClassNames) {
        this(Arrays.asList(connectionName), requiredClassNames);
    }

    protected ContainerConnectionDetailsFactory(List<String> connectionNames, String ... requiredClassNames) {
        Assert.notEmpty(connectionNames, (String)"ConnectionNames must contain at least one name");
        this.connectionNames = connectionNames;
        this.requiredClassNames = requiredClassNames;
    }

    public final D getConnectionDetails(ContainerConnectionSource<C> source) {
        if (!this.hasRequiredClasses()) {
            return null;
        }
        try {
            Class<?>[] generics = this.resolveGenerics();
            Class<?> requiredContainerType = generics[0];
            Class<?> requiredConnectionDetailsType = generics[1];
            if (this.sourceAccepts(source, requiredContainerType, requiredConnectionDetailsType)) {
                return this.getContainerConnectionDetails(source);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    protected boolean sourceAccepts(ContainerConnectionSource<C> source, Class<?> requiredContainerType, Class<?> requiredConnectionDetailsType) {
        for (String requiredConnectionName : this.connectionNames) {
            if (!source.accepts(requiredConnectionName, requiredContainerType, requiredConnectionDetailsType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredClasses() {
        return ObjectUtils.isEmpty((Object[])this.requiredClassNames) || Arrays.stream(this.requiredClassNames).allMatch(requiredClassName -> ClassUtils.isPresent((String)requiredClassName, null));
    }

    private Class<?>[] resolveGenerics() {
        return ResolvableType.forClass(ContainerConnectionDetailsFactory.class, this.getClass()).resolveGenerics();
    }

    protected abstract D getContainerConnectionDetails(ContainerConnectionSource<C> var1);

    static class ContainerConnectionDetailsFactoriesRuntimeHints
    implements RuntimeHintsRegistrar {
        private static final Log logger = LogFactory.getLog(ContainerConnectionDetailsFactoriesRuntimeHints.class);

        ContainerConnectionDetailsFactoriesRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader).load(ConnectionDetailsFactory.class, SpringFactoriesLoader.FailureHandler.logging((Log)logger)).stream().flatMap(this::requiredClassNames).forEach(requiredClassName -> hints.reflection().registerTypeIfPresent(classLoader, requiredClassName, new MemberCategory[0]));
        }

        private Stream<String> requiredClassNames(ConnectionDetailsFactory<?, ?> connectionDetailsFactory) {
            Stream<String> stream;
            if (connectionDetailsFactory instanceof ContainerConnectionDetailsFactory) {
                ContainerConnectionDetailsFactory containerConnectionDetailsFactory = (ContainerConnectionDetailsFactory)connectionDetailsFactory;
                stream = Stream.of(containerConnectionDetailsFactory.requiredClassNames);
            } else {
                stream = Stream.empty();
            }
            return stream;
        }
    }

    protected static class ContainerConnectionDetails<C extends Container<?>>
    implements ConnectionDetails,
    OriginProvider,
    InitializingBean,
    ApplicationContextAware {
        private final ContainerConnectionSource<C> source;
        private volatile C container;

        protected ContainerConnectionDetails(ContainerConnectionSource<C> source) {
            Assert.notNull(source, (String)"Source must not be null");
            this.source = source;
        }

        public void afterPropertiesSet() throws Exception {
            this.container = (Container)this.source.getContainerSupplier().get();
        }

        protected final C getContainer() {
            Assert.state((this.container != null ? 1 : 0) != 0, (String)"Container cannot be obtained before the connection details bean has been initialized");
            C c = this.container;
            if (c instanceof Startable) {
                Startable startable = (Startable)c;
                startable.start();
            }
            return this.container;
        }

        public Origin getOrigin() {
            return this.source.getOrigin();
        }

        @Deprecated(since="3.4.0", forRemoval=true)
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        }
    }
}

