/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

public class LocalHostUriTemplateHandler
extends RootUriTemplateHandler {
    private final Environment environment;
    private final String scheme;
    private RelaxedPropertyResolver serverPropertyResolver;

    public LocalHostUriTemplateHandler(Environment environment) {
        this(environment, "http");
    }

    public LocalHostUriTemplateHandler(Environment environment, String scheme) {
        super((UriTemplateHandler)new DefaultUriTemplateHandler());
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)scheme, (String)"Scheme must not be null");
        this.environment = environment;
        this.scheme = scheme;
        this.serverPropertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "server.");
    }

    public String getRootUri() {
        String port = this.environment.getProperty("local.server.port", "8080");
        String contextPath = this.serverPropertyResolver.getProperty("context-path", "");
        return this.scheme + "://localhost:" + port + contextPath;
    }
}

