/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.BasicJsonTester;
import org.springframework.boot.test.json.GsonTester;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(name={"org.assertj.core.api.Assert"})
@ConditionalOnProperty(value={"spring.test.jsontesters.enabled"})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, GsonAutoConfiguration.class})
public class JsonTestersAutoConfiguration {
    @Bean
    public static JsonMarshalTestersBeanPostProcessor jsonMarshalTestersBeanPostProcessor() {
        return new JsonMarshalTestersBeanPostProcessor();
    }

    @Bean
    @Scope(value="prototype")
    public FactoryBean<BasicJsonTester> basicJsonTesterFactoryBean() {
        return new JsonTesterFactoryBean(BasicJsonTester.class, null);
    }

    private static class JsonMarshalTestersBeanPostProcessor
    extends InstantiationAwareBeanPostProcessorAdapter {
        private JsonMarshalTestersBeanPostProcessor() {
        }

        public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
            ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    JsonMarshalTestersBeanPostProcessor.this.processField(bean, field);
                }
            });
            return bean;
        }

        private void processField(Object bean, Field field) {
            if (AbstractJsonMarshalTester.class.isAssignableFrom(field.getType()) || BasicJsonTester.class.isAssignableFrom(field.getType())) {
                ResolvableType type = ResolvableType.forField((Field)field).getGeneric(new int[0]);
                ReflectionUtils.makeAccessible((Field)field);
                Object tester = ReflectionUtils.getField((Field)field, (Object)bean);
                if (tester != null) {
                    ReflectionTestUtils.invokeMethod((Object)tester, (String)"initialize", (Object[])new Object[]{bean.getClass(), type});
                }
            }
        }
    }

    private static class JsonTesterFactoryBean<T, M>
    implements FactoryBean<T> {
        private final Class<?> objectType;
        private final M marshaller;

        JsonTesterFactoryBean(Class<?> objectType, M marshaller) {
            this.objectType = objectType;
            this.marshaller = marshaller;
        }

        public boolean isSingleton() {
            return false;
        }

        public T getObject() throws Exception {
            Constructor<?>[] constructors;
            if (this.marshaller == null) {
                Constructor<?> constructor = this.objectType.getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(constructor);
                return (T)BeanUtils.instantiateClass(constructor, (Object[])new Object[0]);
            }
            for (Constructor<?> constructor : constructors = this.objectType.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isInstance(this.marshaller)) continue;
                ReflectionUtils.makeAccessible(constructor);
                return (T)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this.marshaller});
            }
            throw new IllegalStateException(this.objectType + " does not have a usable constructor");
        }

        public Class<?> getObjectType() {
            return this.objectType;
        }
    }

    @ConditionalOnClass(value={Gson.class})
    private static class GsonJsonTestersConfiguration {
        private GsonJsonTestersConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnBean(value={Gson.class})
        public FactoryBean<GsonTester<?>> gsonTesterFactoryBean(Gson gson) {
            return new JsonTesterFactoryBean(GsonTester.class, gson);
        }
    }

    @ConditionalOnClass(value={ObjectMapper.class})
    private static class JacksonJsonTestersConfiguration {
        private JacksonJsonTestersConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnBean(value={ObjectMapper.class})
        public FactoryBean<JacksonTester<?>> jacksonTesterFactoryBean(ObjectMapper mapper) {
            return new JsonTesterFactoryBean(JacksonTester.class, mapper);
        }
    }
}

