/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.filter;

import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.filter.FilterAnnotations;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;

public abstract class AnnotationCustomizableTypeExcludeFilter
extends TypeExcludeFilter
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (this.hasAnnotation()) {
            return !this.include(metadataReader, metadataReaderFactory) || this.exclude(metadataReader, metadataReaderFactory);
        }
        return false;
    }

    protected boolean include(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (new FilterAnnotations(this.classLoader, this.getFilters(FilterType.INCLUDE)).anyMatches(metadataReader, metadataReaderFactory)) {
            return true;
        }
        return this.isUseDefaultFilters() && this.defaultInclude(metadataReader, metadataReaderFactory);
    }

    protected boolean defaultInclude(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        for (Class<?> include : this.getDefaultIncludes()) {
            if (!this.isTypeOrAnnotated(metadataReader, metadataReaderFactory, include)) continue;
            return true;
        }
        return false;
    }

    protected boolean exclude(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return new FilterAnnotations(this.classLoader, this.getFilters(FilterType.EXCLUDE)).anyMatches(metadataReader, metadataReaderFactory);
    }

    protected final boolean isTypeOrAnnotated(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory, Class<?> type) throws IOException {
        AnnotationTypeFilter annotationFilter = new AnnotationTypeFilter(type);
        AssignableTypeFilter typeFilter = new AssignableTypeFilter(type);
        return annotationFilter.match(metadataReader, metadataReaderFactory) || typeFilter.match(metadataReader, metadataReaderFactory);
    }

    protected abstract boolean hasAnnotation();

    protected abstract ComponentScan.Filter[] getFilters(FilterType var1);

    protected abstract boolean isUseDefaultFilters();

    protected abstract Set<Class<?>> getDefaultIncludes();

    protected static enum FilterType {
        INCLUDE,
        EXCLUDE;

    }
}

