/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.springframework.boot.loader.jar.JarEntry;
import org.springframework.boot.loader.jar.JarEntryFilter;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.boot.loader.jar.JarURLConnection;

public class Handler
extends URLStreamHandler {
    private static final String FILE_PROTOCOL = "file:";
    private static final String SEPARATOR = "!/";
    private final JarFile jarFile;

    public Handler() {
        this(null);
    }

    public Handler(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        JarFile jarFile = this.jarFile != null ? this.jarFile : this.getJarFileFromUrl(url);
        return new JarURLConnection(url, jarFile);
    }

    public JarFile getJarFileFromUrl(URL url) throws IOException {
        String spec = url.getFile();
        int separatorIndex = spec.indexOf(SEPARATOR);
        if (separatorIndex == -1) {
            throw new MalformedURLException("Jar URL does not contain !/ separator");
        }
        JarFile jar = null;
        while (separatorIndex != -1) {
            String name = spec.substring(0, separatorIndex);
            jar = jar == null ? this.getRootJarFile(name) : this.getNestedJarFile(jar, name);
            spec = spec.substring(separatorIndex + SEPARATOR.length());
            separatorIndex = spec.indexOf(SEPARATOR);
        }
        return jar;
    }

    private JarFile getRootJarFile(String name) throws IOException {
        try {
            if (!name.startsWith(FILE_PROTOCOL)) {
                throw new IllegalStateException("Not a file URL");
            }
            String path = name.substring(FILE_PROTOCOL.length());
            return new JarFile(new File(path), new JarEntryFilter[0]);
        }
        catch (Exception ex) {
            throw new IOException("Unable to open root Jar file '" + name + "'", ex);
        }
    }

    private JarFile getNestedJarFile(JarFile jarFile, String name) throws IOException {
        JarEntry jarEntry = jarFile.getJarEntry(name);
        if (jarEntry == null) {
            throw new IOException("Unable to find nested jar '" + name + "' from '" + jarFile + "'");
        }
        return jarFile.getNestedJarFile(jarEntry, new JarEntryFilter[0]);
    }
}

