/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.archive;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import org.springframework.boot.loader.AsciiBytes;

public abstract class Archive {
    public abstract URL getUrl() throws MalformedURLException;

    public String getMainClass() throws Exception {
        Manifest manifest = this.getManifest();
        String mainClass = null;
        if (manifest != null) {
            mainClass = manifest.getMainAttributes().getValue("Start-Class");
        }
        if (mainClass == null) {
            throw new IllegalStateException("No 'Start-Class' manifest entry specified in " + this);
        }
        return mainClass;
    }

    public String toString() {
        try {
            return this.getUrl().toString();
        }
        catch (Exception ex) {
            return "archive";
        }
    }

    public abstract Manifest getManifest() throws IOException;

    public abstract Collection<Entry> getEntries();

    public abstract List<Archive> getNestedArchives(EntryFilter var1) throws IOException;

    public abstract Archive getFilteredArchive(EntryRenameFilter var1) throws IOException;

    public static interface EntryRenameFilter {
        public AsciiBytes apply(AsciiBytes var1, Entry var2);
    }

    public static interface EntryFilter {
        public boolean matches(Entry var1);
    }

    public static interface Entry {
        public boolean isDirectory();

        public AsciiBytes getName();
    }
}

