/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.JarFileArchive;

public class ExplodedArchive
extends Archive {
    private static final Set<String> SKIPPED_NAMES = new HashSet<String>(Arrays.asList(".", ".."));
    private static final Object MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private File root;
    private Map<String, Archive.Entry> entries = new LinkedHashMap<String, Archive.Entry>();
    private Manifest manifest;

    public ExplodedArchive(File root) {
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException("Invalid source folder " + root);
        }
        this.root = root;
        this.buildEntries(root);
        this.entries = Collections.unmodifiableMap(this.entries);
    }

    private ExplodedArchive(File root, Map<String, Archive.Entry> entries) {
        this.root = root;
        this.entries = Collections.unmodifiableMap(entries);
    }

    private void buildEntries(File file) {
        if (!file.equals(this.root)) {
            String name = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            if (file.isDirectory()) {
                name = name + "/";
            }
            this.entries.put(name, new FileEntry(name, file));
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (SKIPPED_NAMES.contains(child.getName())) continue;
                this.buildEntries(child);
            }
        }
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        FilteredURLStreamHandler handler = new FilteredURLStreamHandler();
        return new URL("file", "", -1, this.root.getAbsolutePath() + "/", handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        if (this.manifest == null && this.entries.containsKey(MANIFEST_ENTRY_NAME)) {
            FileEntry entry = (FileEntry)this.entries.get(MANIFEST_ENTRY_NAME);
            FileInputStream inputStream = new FileInputStream(entry.getFile());
            try {
                this.manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return this.manifest;
    }

    @Override
    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        for (Archive.Entry entry : this.getEntries()) {
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    @Override
    public Collection<Archive.Entry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    protected Archive getNestedArchive(Archive.Entry entry) throws IOException {
        File file = ((FileEntry)entry).getFile();
        return file.isDirectory() ? new ExplodedArchive(file) : new JarFileArchive(file);
    }

    @Override
    public Archive getFilteredArchive(Archive.EntryRenameFilter filter) throws IOException {
        LinkedHashMap<String, Archive.Entry> filteredEntries = new LinkedHashMap<String, Archive.Entry>();
        for (Map.Entry<String, Archive.Entry> entry : this.entries.entrySet()) {
            String filteredName = filter.apply(entry.getKey(), entry.getValue());
            if (filteredName == null) continue;
            filteredEntries.put(filteredName, new FileEntry(filteredName, ((FileEntry)entry.getValue()).getFile()));
        }
        return new ExplodedArchive(this.root, filteredEntries);
    }

    private static class FileNotFoundURLConnection
    extends URLConnection {
        private String name;

        public FileNotFoundURLConnection(URL url, String name) {
            super(url);
            this.name = name;
        }

        @Override
        public void connect() throws IOException {
            throw new FileNotFoundException(this.name);
        }
    }

    private class FilteredURLStreamHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            String name = url.getPath().substring(ExplodedArchive.this.root.getAbsolutePath().length() + 1);
            if (ExplodedArchive.this.entries.containsKey(name)) {
                return new URL(url.toString()).openConnection();
            }
            return new FileNotFoundURLConnection(url, name);
        }
    }

    private class FileEntry
    implements Archive.Entry {
        private final String name;
        private final File file;

        public FileEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

