/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import org.springframework.boot.loader.jar.RandomAccessJarFile;

public class LaunchedURLClassLoader
extends URLClassLoader {
    private final ClassLoader rootClassLoader;

    public LaunchedURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.rootClassLoader = this.findRootClassLoader(parent);
    }

    private ClassLoader findRootClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.getParent() == null) {
                return classLoader;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.rootClassLoader != null) {
            url = this.rootClassLoader.getResource(name);
        }
        return url == null ? this.findResource(name) : url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.rootClassLoader == null) {
            return this.findResources(name);
        }
        final Enumeration<URL> rootResources = this.rootClassLoader.getResources(name);
        final Enumeration<URL> localResources = this.findResources(name);
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return rootResources.hasMoreElements() || localResources.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (rootResources.hasMoreElements()) {
                    return (URL)rootResources.nextElement();
                }
                return (URL)localResources.nextElement();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        LaunchedURLClassLoader launchedURLClassLoader = this;
        synchronized (launchedURLClassLoader) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                loadedClass = this.doLoadClass(name);
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        try {
            if (this.rootClassLoader != null) {
                return this.rootClassLoader.loadClass(name);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            return this.findClass(name);
        }
        catch (Exception exception) {
            return super.loadClass(name, false);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String packageName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1 && this.getPackage(packageName = name.substring(0, lastDot)) == null) {
            try {
                this.definePackageForFindClass(name, packageName);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return super.findClass(name);
    }

    private void definePackageForFindClass(final String name, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    for (URL url : LaunchedURLClassLoader.this.getURLs()) {
                        try {
                            RandomAccessJarFile jarFile;
                            if (!(url.getContent() instanceof RandomAccessJarFile) || (jarFile = (RandomAccessJarFile)url.getContent()).getManifest() == null || jarFile.getJarEntry(path) == null) continue;
                            LaunchedURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }
}

