/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.springframework.boot.loader.Launcher;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.util.SystemPropertyUtils;

public class PropertiesLauncher
extends Launcher {
    private Logger logger = Logger.getLogger(Launcher.class.getName());
    public static final String MAIN = "loader.main";
    public static final String PATH = "loader.path";
    public static final String HOME = "loader.home";
    public static final String CONFIG_NAME = "loader.config.name";
    public static final String CONFIG_LOCATION = "loader.config.location";
    public static final String SET_SYSTEM_PROPERTIES = "loader.system";
    private static final List<String> DEFAULT_PATHS = Arrays.asList("lib/");
    private final File home;
    private List<String> paths = new ArrayList<String>(DEFAULT_PATHS);
    private Properties properties = new Properties();

    public PropertiesLauncher() {
        try {
            this.home = this.getHomeDirectory();
            this.initializeProperties(this.home);
            this.initializePaths();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected File getHomeDirectory() {
        return new File(SystemPropertyUtils.resolvePlaceholders(System.getProperty(HOME, "${user.dir}")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties(File home) throws Exception, IOException {
        String config = SystemPropertyUtils.resolvePlaceholders(System.getProperty(CONFIG_NAME, "application")) + ".properties";
        InputStream resource = this.getClasspathResource(config);
        if (resource == null) {
            resource = this.getResource(new File(home, config).getAbsolutePath());
        }
        if (resource == null) {
            config = SystemPropertyUtils.resolvePlaceholders(System.getProperty(CONFIG_LOCATION, config));
            resource = this.getResource(config);
        }
        if (resource != null) {
            this.logger.info("Found: " + config);
            try {
                this.properties.load(resource);
            }
            finally {
                resource.close();
            }
            for (Object key : Collections.list(this.properties.propertyNames())) {
                String text = this.properties.getProperty((String)key);
                String value = SystemPropertyUtils.resolvePlaceholders(this.properties, text);
                if (value == null) continue;
                this.properties.put(key, value);
            }
            if (SystemPropertyUtils.resolvePlaceholders("${loader.system:false}").equals("true")) {
                this.logger.info("Adding resolved properties to System properties");
                for (Object key : Collections.list(this.properties.propertyNames())) {
                    String value = this.properties.getProperty((String)key);
                    System.setProperty((String)key, value);
                }
            }
        } else {
            this.logger.info("Not found: " + config);
        }
    }

    private InputStream getResource(String config) throws Exception {
        if (config.startsWith("classpath:")) {
            return this.getClasspathResource(config.substring("classpath:".length()));
        }
        if (this.isUrl(config = this.stripFileUrlPrefix(config))) {
            return this.getURLResource(config);
        }
        return this.getFileResource(config);
    }

    private String stripFileUrlPrefix(String config) {
        if (config.startsWith("file:") && (config = config.substring("file:".length())).startsWith("//")) {
            config = config.substring(2);
        }
        return config;
    }

    private boolean isUrl(String config) {
        return config.contains("://");
    }

    private InputStream getClasspathResource(String config) {
        while (config.startsWith("/")) {
            config = config.substring(1);
        }
        config = "/" + config;
        this.logger.fine("Trying classpath: " + config);
        return this.getClass().getResourceAsStream(config);
    }

    private InputStream getFileResource(String config) throws Exception {
        File file = new File(config);
        this.logger.fine("Trying file: " + config);
        if (file.canRead()) {
            return new FileInputStream(file);
        }
        return null;
    }

    private InputStream getURLResource(String config) throws Exception {
        URL url = new URL(config);
        if (this.exists(url)) {
            URLConnection con = url.openConnection();
            try {
                return con.getInputStream();
            }
            catch (IOException ex) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw ex;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            connection.setUseCaches(connection.getClass().getSimpleName().startsWith("JNLP"));
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestMethod("HEAD");
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    boolean bl = true;
                    return bl;
                }
                if (responseCode == 404) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = connection.getContentLength() >= 0;
            return bl;
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    private void initializePaths() throws IOException {
        String path = System.getProperty(PATH);
        if (path == null) {
            path = this.properties.getProperty(PATH);
        }
        if (path != null) {
            this.paths = this.parsePathsProperty(SystemPropertyUtils.resolvePlaceholders(path));
        }
        this.logger.info("Nested archive paths: " + this.paths);
    }

    private List<String> parsePathsProperty(String commaSeparatedPaths) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : commaSeparatedPaths.split(",")) {
            if ((path = this.cleanupPath(path)).equals(".") || path.equals("")) continue;
            paths.add(path);
        }
        return paths;
    }

    @Override
    protected String getMainClass() throws Exception {
        if (System.getProperty(MAIN) != null) {
            return SystemPropertyUtils.resolvePlaceholders(System.getProperty(MAIN));
        }
        if (this.properties.containsKey(MAIN)) {
            return SystemPropertyUtils.resolvePlaceholders(this.properties.getProperty(MAIN));
        }
        return new ExplodedArchive(this.home).getMainClass();
    }

    @Override
    protected List<Archive> getClassPathArchives() throws Exception {
        ArrayList<Archive> lib = new ArrayList<Archive>();
        for (String path : this.paths) {
            String root = this.cleanupPath(this.stripFileUrlPrefix(path));
            File file = new File(root);
            if (!root.startsWith("/")) {
                file = new File(this.home, root);
            }
            if (file.isDirectory()) {
                this.logger.info("Adding classpath entries from " + path);
                ExplodedArchive archive = new ExplodedArchive(file);
                lib.addAll(((Archive)archive).getNestedArchives(new Archive.EntryFilter(){

                    @Override
                    public boolean matches(Archive.Entry entry) {
                        return entry.isDirectory() || entry.getName().endsWith(".jar") || entry.getName().endsWith(".zip");
                    }
                }));
                lib.add(0, archive);
                continue;
            }
            this.logger.info("No directory found at " + path);
        }
        return lib;
    }

    private String cleanupPath(String path) {
        if (!(path = path.trim()).endsWith("/")) {
            path = path + "/";
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    public static void main(String[] args) {
        new PropertiesLauncher().launch(args);
    }
}

