/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure.service;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.ApiversionProperties;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.http.client.autoconfigure.HttpClientSettingsProperties;
import org.springframework.boot.http.client.autoconfigure.HttpClientSettingsPropertyMapper;
import org.springframework.boot.http.client.autoconfigure.PropertiesApiVersionInserter;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

class PropertiesRestClientHttpServiceGroupConfigurer
implements RestClientHttpServiceGroupConfigurer {
    private final HttpServiceClientProperties properties;
    private final HttpClientSettingsPropertyMapper clientSettingsPropertyMapper;
    private final ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder;

    PropertiesRestClientHttpServiceGroupConfigurer(@Nullable ClassLoader classLoader, HttpServiceClientProperties properties, @Nullable SslBundles sslBundles, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> requestFactoryBuilder, @Nullable HttpClientSettings httpClientSettings) {
        this.properties = properties;
        this.clientSettingsPropertyMapper = new HttpClientSettingsPropertyMapper(sslBundles, httpClientSettings);
        this.requestFactoryBuilder = (ClientHttpRequestFactoryBuilder)requestFactoryBuilder.getIfAvailable(() -> ClientHttpRequestFactoryBuilder.detect((ClassLoader)classLoader));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<RestClient.Builder> groups) {
        groups.forEachClient(this::configureClient);
    }

    private void configureClient(HttpServiceGroup group, RestClient.Builder builder) {
        HttpClientProperties clientProperties = (HttpClientProperties)this.properties.get((Object)group.name());
        HttpClientSettings clientSettings = this.clientSettingsPropertyMapper.map((HttpClientSettingsProperties)clientProperties);
        builder.requestFactory(this.requestFactoryBuilder.build(clientSettings));
        if (clientProperties != null) {
            PropertyMapper map = PropertyMapper.get();
            map.from(() -> ((HttpClientProperties)clientProperties).getBaseUrl()).whenHasText().to(arg_0 -> ((RestClient.Builder)builder).baseUrl(arg_0));
            map.from(() -> ((HttpClientProperties)clientProperties).getDefaultHeader()).as(this::putAllHeaders).to(arg_0 -> ((RestClient.Builder)builder).defaultHeaders(arg_0));
            map.from(() -> ((HttpClientProperties)clientProperties).getApiversion()).as(ApiversionProperties::getDefaultVersion).to(arg_0 -> ((RestClient.Builder)builder).defaultApiVersion(arg_0));
            map.from(() -> ((HttpClientProperties)clientProperties).getApiversion()).as(ApiversionProperties::getInsert).as(PropertiesApiVersionInserter::get).to(arg_0 -> ((RestClient.Builder)builder).apiVersionInserter(arg_0));
        }
    }

    private Consumer<HttpHeaders> putAllHeaders(Map<String, List<String>> defaultHeaders) {
        return httpHeaders -> httpHeaders.putAll(defaultHeaders);
    }
}

