/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure.service;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.imperative.ImperativeHttpClientAutoConfiguration;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.RestClientAutoConfiguration;
import org.springframework.boot.restclient.autoconfigure.service.NotReactiveWebApplicationCondition;
import org.springframework.boot.restclient.autoconfigure.service.PropertiesRestClientHttpServiceGroupConfigurer;
import org.springframework.boot.restclient.autoconfigure.service.RestClientCustomizerHttpServiceGroupConfigurer;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.service.registry.HttpServiceProxyRegistry;

@AutoConfiguration(after={ImperativeHttpClientAutoConfiguration.class, RestClientAutoConfiguration.class})
@ConditionalOnClass(value={RestClientAdapter.class})
@ConditionalOnBean(value={HttpServiceProxyRegistry.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={HttpServiceClientProperties.class})
public final class HttpServiceClientAutoConfiguration {
    @Bean
    PropertiesRestClientHttpServiceGroupConfigurer restClientPropertiesHttpServiceGroupConfigurer(ResourceLoader resourceLoader, HttpServiceClientProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> requestFactoryBuilder, ObjectProvider<HttpClientSettings> httpClientSettings) {
        return new PropertiesRestClientHttpServiceGroupConfigurer(resourceLoader.getClassLoader(), properties, (SslBundles)sslBundles.getIfAvailable(), requestFactoryBuilder, (HttpClientSettings)httpClientSettings.getIfAvailable());
    }

    @Bean
    RestClientCustomizerHttpServiceGroupConfigurer restClientCustomizerHttpServiceGroupConfigurer(ObjectProvider<RestClientCustomizer> customizers) {
        return new RestClientCustomizerHttpServiceGroupConfigurer(customizers);
    }
}

