/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.health;

import com.mongodb.reactivestreams.client.MongoClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.springframework.boot.health.contributor.AbstractReactiveHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MongoReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final Document HELLO_COMMAND = Document.parse((String)"{ hello: 1 }");
    private final MongoClient mongoClient;

    public MongoReactiveHealthIndicator(MongoClient mongoClient) {
        super("Mongo health check failed");
        Assert.notNull((Object)mongoClient, (String)"'mongoClient' must not be null");
        this.mongoClient = mongoClient;
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        Mono healthDetails = Flux.from((Publisher)this.mongoClient.listDatabaseNames()).flatMap(database -> Mono.from((Publisher)this.mongoClient.getDatabase(database).runCommand((Bson)HELLO_COMMAND)).map(document -> new HelloResponse((String)database, (Document)document))).collectList().map(responses -> {
            LinkedHashMap<String, Serializable> databaseDetails = new LinkedHashMap<String, Serializable>();
            ArrayList<String> databases = new ArrayList<String>();
            databaseDetails.put("databases", databases);
            for (HelloResponse response : responses) {
                databases.add(response.database());
                databaseDetails.putIfAbsent("maxWireVersion", response.document().getInteger((Object)"maxWireVersion"));
            }
            return databaseDetails;
        });
        return healthDetails.map(details -> builder.up().withDetails(details).build());
    }

    private record HelloResponse(String database, Document document) {
    }
}

