/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.boot.maven.AbstractPackagerMojo;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractPackagerMojo {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(property="spring-boot.repackage.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    private boolean attach = true;
    @Parameter
    private List<Dependency> requiresUnpack;
    @Parameter(defaultValue="false")
    private boolean executable;
    @Parameter
    private File embeddedLaunchScript;
    @Parameter
    private Properties embeddedLaunchScriptProperties;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping repackaging as per configuration.");
            return;
        }
        this.repackage();
    }

    private void repackage() throws MojoExecutionException {
        Artifact source = this.getSourceArtifact();
        File target = this.getTargetFile();
        Repackager repackager = this.getRepackager(source.getFile());
        Libraries libraries = this.getLibraries(this.requiresUnpack);
        try {
            LaunchScript launchScript = this.getLaunchScript();
            repackager.repackage(target, libraries, launchScript, this.parseOutputTimestamp());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        this.updateArtifact(source, target, repackager.getBackupFile());
    }

    private FileTime parseOutputTimestamp() {
        if (this.outputTimestamp == null || this.outputTimestamp.length() < 2) {
            return null;
        }
        return FileTime.from(this.getOutputTimestampEpochSeconds(), TimeUnit.SECONDS);
    }

    private long getOutputTimestampEpochSeconds() {
        try {
            return Long.parseLong(this.outputTimestamp);
        }
        catch (NumberFormatException ex) {
            return OffsetDateTime.parse(this.outputTimestamp).toInstant().getEpochSecond();
        }
    }

    private Artifact getSourceArtifact() {
        Artifact sourceArtifact = this.getArtifact(this.classifier);
        return sourceArtifact != null ? sourceArtifact : this.project.getArtifact();
    }

    private Artifact getArtifact(String classifier) {
        if (classifier != null) {
            for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                if (!classifier.equals(attachedArtifact.getClassifier()) || attachedArtifact.getFile() == null || !attachedArtifact.getFile().isFile()) continue;
                return attachedArtifact;
            }
        }
        return null;
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier != null ? this.classifier.trim() : "";
        if (!classifier.isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    private Repackager getRepackager(File source) {
        return this.getConfiguredPackager(() -> new Repackager(source));
    }

    private LaunchScript getLaunchScript() throws IOException {
        if (this.executable || this.embeddedLaunchScript != null) {
            return new DefaultLaunchScript(this.embeddedLaunchScript, (Map)this.buildLaunchScriptProperties());
        }
        return null;
    }

    private Properties buildLaunchScriptProperties() {
        Properties properties = new Properties();
        if (this.embeddedLaunchScriptProperties != null) {
            properties.putAll((Map<?, ?>)this.embeddedLaunchScriptProperties);
        }
        this.putIfMissing(properties, "initInfoProvides", this.project.getArtifactId());
        this.putIfMissing(properties, "initInfoShortDescription", this.project.getName(), this.project.getArtifactId());
        this.putIfMissing(properties, "initInfoDescription", this.removeLineBreaks(this.project.getDescription()), this.project.getName(), this.project.getArtifactId());
        return properties;
    }

    private String removeLineBreaks(String description) {
        return description != null ? WHITE_SPACE_PATTERN.matcher(description).replaceAll(" ") : null;
    }

    private void putIfMissing(Properties properties, String key, String ... valueCandidates) {
        if (!properties.containsKey(key)) {
            for (String candidate : valueCandidates) {
                if (candidate == null || candidate.isEmpty()) continue;
                properties.put(key, candidate);
                return;
            }
        }
    }

    private void updateArtifact(Artifact source, File target, File original) {
        if (this.attach) {
            this.attachArtifact(source, target);
        } else if (source.getFile().equals(target) && original.exists()) {
            String artifactId = this.classifier != null ? "artifact with classifier " + this.classifier : "main artifact";
            this.getLog().info((CharSequence)String.format("Updating %s %s to %s", artifactId, source.getFile(), original));
            source.setFile(original);
        } else if (this.classifier != null) {
            this.getLog().info((CharSequence)("Creating repackaged archive " + target + " with classifier " + this.classifier));
        }
    }

    private void attachArtifact(Artifact source, File target) {
        if (this.classifier != null && !source.getFile().equals(target)) {
            this.getLog().info((CharSequence)("Attaching repackaged archive " + target + " with classifier " + this.classifier));
            this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), this.classifier, target);
        } else {
            String artifactId = this.classifier != null ? "artifact with classifier " + this.classifier : "main artifact";
            this.getLog().info((CharSequence)("Replacing " + artifactId + " with repackaged archive"));
            source.setFile(target);
        }
    }
}

