/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.DefaultTimeZoneOffset;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.LaunchScript;

public class JarWriter
extends AbstractJarWriter
implements AutoCloseable {
    private final JarArchiveOutputStream jarOutputStream;
    private final FileTime lastModifiedTime;

    public JarWriter(File file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public JarWriter(File file, LaunchScript launchScript) throws FileNotFoundException, IOException {
        this(file, launchScript, null);
    }

    public JarWriter(File file, LaunchScript launchScript, FileTime lastModifiedTime) throws FileNotFoundException, IOException {
        this.jarOutputStream = new JarArchiveOutputStream((OutputStream)new FileOutputStream(file));
        if (launchScript != null) {
            this.jarOutputStream.writePreamble(launchScript.toByteArray());
            file.setExecutable(true);
        }
        this.jarOutputStream.setEncoding("UTF-8");
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    protected void writeToArchive(ZipEntry entry, EntryWriter entryWriter) throws IOException {
        JarArchiveEntry jarEntry = this.asJarArchiveEntry(entry);
        if (this.lastModifiedTime != null) {
            jarEntry.setTime(DefaultTimeZoneOffset.INSTANCE.removeFrom(this.lastModifiedTime).toMillis());
        }
        this.jarOutputStream.putArchiveEntry((ZipArchiveEntry)jarEntry);
        if (entryWriter != null) {
            entryWriter.write((OutputStream)this.jarOutputStream);
        }
        this.jarOutputStream.closeArchiveEntry();
    }

    private JarArchiveEntry asJarArchiveEntry(ZipEntry entry) throws ZipException {
        if (entry instanceof JarArchiveEntry) {
            JarArchiveEntry jarArchiveEntry = (JarArchiveEntry)entry;
            return jarArchiveEntry;
        }
        return new JarArchiveEntry(entry);
    }

    @Override
    public void close() throws IOException {
        this.jarOutputStream.close();
    }
}

