/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools.layer;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.layer.ContentFilter;
import org.springframework.boot.loader.tools.layer.ContentSelector;
import org.springframework.util.Assert;

public class IncludeExcludeContentSelector<T>
implements ContentSelector<T> {
    private final Layer layer;
    private final List<ContentFilter<T>> includes;
    private final List<ContentFilter<T>> excludes;

    public IncludeExcludeContentSelector(Layer layer, List<ContentFilter<T>> includes, List<ContentFilter<T>> excludes) {
        this(layer, includes, excludes, Function.identity());
    }

    public <S> IncludeExcludeContentSelector(Layer layer, List<S> includes, List<S> excludes, Function<S, ContentFilter<T>> filterFactory) {
        Assert.notNull((Object)layer, (String)"Layer must not be null");
        Assert.notNull(filterFactory, (String)"FilterFactory must not be null");
        this.layer = layer;
        this.includes = includes != null ? this.adapt(includes, filterFactory) : Collections.emptyList();
        this.excludes = excludes != null ? this.adapt(excludes, filterFactory) : Collections.emptyList();
    }

    private <S> List<ContentFilter<T>> adapt(List<S> list, Function<S, ContentFilter<T>> mapper) {
        return list.stream().map(mapper).toList();
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public boolean contains(T item) {
        return this.isIncluded(item) && !this.isExcluded(item);
    }

    private boolean isIncluded(T item) {
        if (this.includes.isEmpty()) {
            return true;
        }
        for (ContentFilter<T> include : this.includes) {
            if (!include.matches(item)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(T item) {
        if (this.excludes.isEmpty()) {
            return false;
        }
        for (ContentFilter<T> exclude : this.excludes) {
            if (!exclude.matches(item)) continue;
            return true;
        }
        return false;
    }
}

