/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.node.NullNode;

public abstract class ObjectValueDeserializer<T>
extends ValueDeserializer<T> {
    public final T deserialize(JsonParser jp, DeserializationContext ctxt) {
        TreeNode tree = jp.readValueAsTree();
        if (tree instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)tree;
            return this.deserializeObject(jp, ctxt, jsonNode);
        }
        throw new IllegalStateException("JsonParser " + String.valueOf(jp) + " produced " + String.valueOf(tree.getClass()) + " that is not a JsonNode");
    }

    protected abstract T deserializeObject(JsonParser var1, DeserializationContext var2, JsonNode var3);

    protected final <D, R> @Nullable R nullSafeValue(@Nullable JsonNode jsonNode, Class<D> type, Function<D, R> mapper) {
        D value = this.nullSafeValue(jsonNode, type);
        return value != null ? (R)mapper.apply(value) : null;
    }

    protected final <D> @Nullable D nullSafeValue(@Nullable JsonNode jsonNode, Class<D> type) {
        Assert.notNull(type, (String)"'type' must not be null");
        if (jsonNode == null) {
            return null;
        }
        if (type == String.class) {
            return (D)jsonNode.stringValue();
        }
        if (type == Boolean.class) {
            return (D)Boolean.valueOf(jsonNode.booleanValue());
        }
        if (type == Long.class) {
            return (D)Long.valueOf(jsonNode.longValue());
        }
        if (type == Integer.class) {
            return (D)Integer.valueOf(jsonNode.intValue());
        }
        if (type == Short.class) {
            return (D)Short.valueOf(jsonNode.shortValue());
        }
        if (type == Double.class) {
            return (D)Double.valueOf(jsonNode.doubleValue());
        }
        if (type == Float.class) {
            return (D)Float.valueOf(jsonNode.floatValue());
        }
        if (type == BigDecimal.class) {
            return (D)jsonNode.decimalValue();
        }
        if (type == BigInteger.class) {
            return (D)jsonNode.bigIntegerValue();
        }
        throw new IllegalArgumentException("Unsupported value type " + type.getName());
    }

    protected final JsonNode getRequiredNode(JsonNode tree, String fieldName) {
        Assert.notNull((Object)tree, (String)"'tree' must not be null");
        JsonNode node = tree.get(fieldName);
        Assert.state((node != null && !(node instanceof NullNode) ? 1 : 0) != 0, () -> "Missing JSON field '" + fieldName + "'");
        return node;
    }
}

