/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.autoconfigure.rsocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import io.rsocket.core.RSocketServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.graphql.autoconfigure.GraphQlAutoConfiguration;
import org.springframework.boot.graphql.autoconfigure.rsocket.GraphQlRSocketController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.server.GraphQlRSocketHandler;
import org.springframework.graphql.server.RSocketGraphQlInterceptor;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.util.MimeType;
import reactor.netty.http.server.HttpServer;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(after={GraphQlAutoConfiguration.class}, afterName={"org.springframework.boot.rsocket.autoconfigure.RSocketMessagingAutoConfiguration", "org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration", "org.springframework.boot.jackson2.autoconfigure.Jackson2AutoConfiguration"})
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class, RSocketServer.class, HttpServer.class})
@ConditionalOnBean(value={RSocketMessageHandler.class, AnnotatedControllerConfigurer.class})
@ConditionalOnProperty(value={"spring.graphql.rsocket.mapping"})
public final class GraphQlRSocketAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    GraphQlRSocketHandler graphQlRSocketHandler(ExecutionGraphQlService graphQlService, ObjectProvider<RSocketGraphQlInterceptor> interceptors, JsonEncoderSupplier jsonEncoderSupplier) {
        return new GraphQlRSocketHandler(graphQlService, interceptors.orderedStream().toList(), jsonEncoderSupplier.jsonEncoder());
    }

    @Bean
    @ConditionalOnMissingBean
    GraphQlRSocketController graphQlRSocketController(GraphQlRSocketHandler handler) {
        return new GraphQlRSocketController(handler);
    }

    static interface JsonEncoderSupplier {
        public Encoder<?> jsonEncoder();
    }

    static class NoJacksonOrJackson2Preferred
    extends AnyNestedCondition {
        NoJacksonOrJackson2Preferred() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"spring.graphql.rsocket.preferred-json-mapper"}, havingValue="jackson2")
        static class Jackson2Preferred {
            Jackson2Preferred() {
            }
        }

        @ConditionalOnMissingClass(value={"tools.jackson.databind.json.JsonMapper"})
        static class NoJackson {
            NoJackson() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ObjectMapper.class})
    @Conditional(value={NoJacksonOrJackson2Preferred.class})
    @Deprecated(since="4.0.0", forRemoval=true)
    static class Jackson2JsonEncoderSupplierConfiguration {
        Jackson2JsonEncoderSupplierConfiguration() {
        }

        @Bean
        JsonEncoderSupplier jackson2JsonEncoderSupplier(ObjectMapper objectMapper) {
            return () -> new Jackson2JsonEncoder(objectMapper, new MimeType[0]);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={JsonMapper.class})
    @ConditionalOnProperty(name={"spring.graphql.rsocket.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    static class JacksonJsonEncoderSupplierConfiguration {
        JacksonJsonEncoderSupplierConfiguration() {
        }

        @Bean
        JsonEncoderSupplier jacksonJsonEncoderSupplier(JsonMapper jsonMapper) {
            return () -> new JacksonJsonEncoder(jsonMapper);
        }
    }
}

