/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.cyclonedx.gradle.CyclonedxAggregateTask;
import org.cyclonedx.gradle.CyclonedxPlugin;
import org.cyclonedx.model.Component;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SpringBootPlugin;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.bundling.BootWar;

final class CyclonedxPluginAction
implements PluginApplicationAction {
    CyclonedxPluginAction() {
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return CyclonedxPlugin.class;
    }

    public void execute(Project project) {
        TaskProvider cycloneDxTaskProvider = project.getTasks().named("cyclonedxBom", CyclonedxAggregateTask.class);
        this.configureCycloneDxTask((TaskProvider<CyclonedxAggregateTask>)cycloneDxTaskProvider, project);
        this.configureJavaPlugin(project, (TaskProvider<CyclonedxAggregateTask>)cycloneDxTaskProvider);
        this.configureSpringBootPlugin(project, (TaskProvider<CyclonedxAggregateTask>)cycloneDxTaskProvider);
    }

    private void configureCycloneDxTask(TaskProvider<CyclonedxAggregateTask> taskProvider, Project project) {
        taskProvider.configure(task -> {
            task.getProjectType().convention((Object)Component.Type.APPLICATION);
            task.getXmlOutput().unsetConvention();
            task.getJsonOutput().convention(project.getLayout().getBuildDirectory().file("reports/cyclonedx/application.cdx.json"));
            task.getIncludeLicenseText().convention((Object)false);
        });
    }

    private void configureJavaPlugin(Project project, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider) {
        this.configurePlugin(project, JavaPlugin.class, javaPlugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSet main = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
            this.configureTask(project, main.getProcessResourcesTaskName(), Copy.class, copy -> {
                copy.dependsOn(new Object[]{cycloneDxTaskProvider});
                Provider sbomFileName = cycloneDxTaskProvider.flatMap(cycloneDxTask -> cycloneDxTask.getJsonOutput().map(file -> file.getAsFile().getName()));
                copy.from((Object)cycloneDxTaskProvider, spec -> spec.include(element -> element.getName().equals(sbomFileName.get())).into((Object)"META-INF/sbom"));
            });
        });
    }

    private void configureSpringBootPlugin(Project project, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider) {
        this.configurePlugin(project, SpringBootPlugin.class, springBootPlugin -> {
            this.configureBootJarTask(project, cycloneDxTaskProvider);
            this.configureBootWarTask(project, cycloneDxTaskProvider);
        });
    }

    private void configureBootJarTask(Project project, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider) {
        this.configureTask(project, "bootJar", BootJar.class, bootJar -> this.configureBootJarTask((BootJar)bootJar, cycloneDxTaskProvider));
    }

    private void configureBootWarTask(Project project, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider) {
        this.configureTask(project, "bootWar", BootWar.class, bootWar -> this.configureBootWarTask((BootWar)bootWar, cycloneDxTaskProvider));
    }

    private void configureBootJarTask(BootJar task, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider) {
        this.configureJarTask(task, cycloneDxTaskProvider, "");
    }

    private void configureBootWarTask(BootWar task, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider) {
        this.configureJarTask((Jar)task, cycloneDxTaskProvider, "WEB-INF/classes/");
    }

    private void configureJarTask(Jar task, TaskProvider<CyclonedxAggregateTask> cycloneDxTaskProvider, String sbomLocationPrefix) {
        Provider sbomFileName = cycloneDxTaskProvider.map(cycloneDxTask -> "META-INF/sbom/" + ((RegularFile)cycloneDxTask.getJsonOutput().get()).getAsFile().getName());
        task.manifest(manifest -> {
            manifest.getAttributes().put((Object)"Sbom-Format", (Object)"CycloneDX");
            manifest.getAttributes().put((Object)"Sbom-Location", (Object)sbomFileName.map(fileName -> sbomLocationPrefix + fileName));
        });
    }

    private <T extends Task> void configureTask(Project project, String name, Class<T> type, Action<T> action) {
        project.getTasks().withType(type).configureEach(task -> {
            if (task.getName().equals(name)) {
                action.execute(task);
            }
        });
    }

    private <T extends Plugin<?>> void configurePlugin(Project project, Class<T> plugin, Action<T> action) {
        project.getPlugins().withType(plugin, action);
    }
}

