/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.docker.compose.core.DockerComposeFile;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.ConnectionNamePredicate;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DockerComposeConnectionDetailsFactory<D extends ConnectionDetails>
implements ConnectionDetailsFactory<DockerComposeConnectionSource, D> {
    private final Predicate<DockerComposeConnectionSource> predicate;
    private final String[] requiredClassNames;

    protected DockerComposeConnectionDetailsFactory(String connectionName, String ... requiredClassNames) {
        this(new ConnectionNamePredicate(connectionName), requiredClassNames);
    }

    protected DockerComposeConnectionDetailsFactory(String[] connectionNames, String ... requiredClassNames) {
        this(new ConnectionNamePredicate(connectionNames), requiredClassNames);
    }

    protected DockerComposeConnectionDetailsFactory(Predicate<DockerComposeConnectionSource> predicate, String ... requiredClassNames) {
        this.predicate = predicate;
        this.requiredClassNames = requiredClassNames;
    }

    public final D getConnectionDetails(DockerComposeConnectionSource source) {
        return !this.accept(source) ? null : (D)this.getDockerComposeConnectionDetails(source);
    }

    private boolean accept(DockerComposeConnectionSource source) {
        return this.hasRequiredClasses() && this.predicate.test(source);
    }

    private boolean hasRequiredClasses() {
        return ObjectUtils.isEmpty((Object[])this.requiredClassNames) || Arrays.stream(this.requiredClassNames).allMatch(requiredClassName -> ClassUtils.isPresent((String)requiredClassName, null));
    }

    protected abstract D getDockerComposeConnectionDetails(DockerComposeConnectionSource var1);

    protected static class DockerComposeConnectionDetails
    implements ConnectionDetails,
    OriginProvider {
        private final Origin origin;
        private volatile SslBundle sslBundle;

        protected DockerComposeConnectionDetails(RunningService runningService) {
            Assert.notNull((Object)runningService, (String)"'runningService' must not be null");
            this.origin = Origin.from((Object)runningService);
        }

        public Origin getOrigin() {
            return this.origin;
        }

        protected SslBundle getSslBundle(RunningService service) {
            SslBundle sslBundle;
            if (this.sslBundle != null) {
                return this.sslBundle;
            }
            SslBundle jksSslBundle = this.getJksSslBundle(service);
            SslBundle pemSslBundle = this.getPemSslBundle(service);
            if (jksSslBundle == null && pemSslBundle == null) {
                return null;
            }
            if (jksSslBundle != null && pemSslBundle != null) {
                throw new IllegalStateException("Mutually exclusive JKS and PEM ssl bundles have been configured");
            }
            this.sslBundle = sslBundle = jksSslBundle != null ? jksSslBundle : pemSslBundle;
            return sslBundle;
        }

        private SslBundle getJksSslBundle(RunningService service) {
            JksSslStoreDetails keyStoreDetails = this.getJksSslStoreDetails(service, "keystore");
            JksSslStoreDetails trustStoreDetails = this.getJksSslStoreDetails(service, "truststore");
            if (keyStoreDetails == null && trustStoreDetails == null) {
                return null;
            }
            SslBundleKey key = SslBundleKey.of((String)service.labels().get("org.springframework.boot.sslbundle.jks.key.alias"), (String)service.labels().get("org.springframework.boot.sslbundle.jks.key.password"));
            SslOptions options = this.createSslOptions(service.labels().get("org.springframework.boot.sslbundle.jks.options.ciphers"), service.labels().get("org.springframework.boot.sslbundle.jks.options.enabled-protocols"));
            String protocol = service.labels().get("org.springframework.boot.sslbundle.jks.protocol");
            Path workingDirectory = this.getWorkingDirectory(service);
            return SslBundle.of((SslStoreBundle)new JksSslStoreBundle(keyStoreDetails, trustStoreDetails, this.getResourceLoader(workingDirectory)), (SslBundleKey)key, (SslOptions)options, (String)protocol);
        }

        private ResourceLoader getResourceLoader(Path workingDirectory) {
            ClassLoader classLoader = ApplicationResourceLoader.get().getClassLoader();
            return ApplicationResourceLoader.get((ClassLoader)classLoader, (SpringFactoriesLoader)SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader), (Path)workingDirectory);
        }

        private JksSslStoreDetails getJksSslStoreDetails(RunningService service, String storeType) {
            String type = service.labels().get("org.springframework.boot.sslbundle.jks.%s.type".formatted(storeType));
            String provider = service.labels().get("org.springframework.boot.sslbundle.jks.%s.provider".formatted(storeType));
            String location = service.labels().get("org.springframework.boot.sslbundle.jks.%s.location".formatted(storeType));
            String password = service.labels().get("org.springframework.boot.sslbundle.jks.%s.password".formatted(storeType));
            if (location == null) {
                return null;
            }
            return new JksSslStoreDetails(type, provider, location, password);
        }

        private Path getWorkingDirectory(RunningService runningService) {
            DockerComposeFile composeFile = runningService.composeFile();
            if (composeFile == null || CollectionUtils.isEmpty(composeFile.getFiles())) {
                return Path.of(".", new String[0]);
            }
            return composeFile.getFiles().get(0).toPath().getParent();
        }

        private SslOptions createSslOptions(String ciphers, String enabledProtocols) {
            Set ciphersSet = null;
            if (StringUtils.hasLength((String)ciphers)) {
                ciphersSet = StringUtils.commaDelimitedListToSet((String)ciphers);
            }
            Set enabledProtocolsSet = null;
            if (StringUtils.hasLength((String)enabledProtocols)) {
                enabledProtocolsSet = StringUtils.commaDelimitedListToSet((String)enabledProtocols);
            }
            return SslOptions.of((Set)ciphersSet, (Set)enabledProtocolsSet);
        }

        private SslBundle getPemSslBundle(RunningService service) {
            PemSslStoreDetails keyStoreDetails = this.getPemSslStoreDetails(service, "keystore");
            PemSslStoreDetails trustStoreDetails = this.getPemSslStoreDetails(service, "truststore");
            if (keyStoreDetails == null && trustStoreDetails == null) {
                return null;
            }
            SslBundleKey key = SslBundleKey.of((String)service.labels().get("org.springframework.boot.sslbundle.pem.key.alias"), (String)service.labels().get("org.springframework.boot.sslbundle.pem.key.password"));
            SslOptions options = this.createSslOptions(service.labels().get("org.springframework.boot.sslbundle.pem.options.ciphers"), service.labels().get("org.springframework.boot.sslbundle.pem.options.enabled-protocols"));
            String protocol = service.labels().get("org.springframework.boot.sslbundle.pem.protocol");
            Path workingDirectory = this.getWorkingDirectory(service);
            ResourceLoader resourceLoader = this.getResourceLoader(workingDirectory);
            return SslBundle.of((SslStoreBundle)new PemSslStoreBundle(PemSslStore.load((PemSslStoreDetails)keyStoreDetails, (ResourceLoader)resourceLoader), PemSslStore.load((PemSslStoreDetails)trustStoreDetails, (ResourceLoader)resourceLoader)), (SslBundleKey)key, (SslOptions)options, (String)protocol);
        }

        private PemSslStoreDetails getPemSslStoreDetails(RunningService service, String storeType) {
            String type = service.labels().get("org.springframework.boot.sslbundle.pem.%s.type".formatted(storeType));
            String certificate = service.labels().get("org.springframework.boot.sslbundle.pem.%s.certificate".formatted(storeType));
            String privateKey = service.labels().get("org.springframework.boot.sslbundle.pem.%s.private-key".formatted(storeType));
            String privateKeyPassword = service.labels().get("org.springframework.boot.sslbundle.pem.%s.private-key-password".formatted(storeType));
            if (certificate == null && privateKey == null) {
                return null;
            }
            return new PemSslStoreDetails(type, certificate, privateKey, privateKeyPassword);
        }
    }
}

