/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.docker.compose.core.DefaultRunningService;
import org.springframework.boot.docker.compose.core.DockerCli;
import org.springframework.boot.docker.compose.core.DockerCliCommand;
import org.springframework.boot.docker.compose.core.DockerCliComposePsResponse;
import org.springframework.boot.docker.compose.core.DockerCliInspectResponse;
import org.springframework.boot.docker.compose.core.DockerCompose;
import org.springframework.boot.docker.compose.core.DockerComposeFile;
import org.springframework.boot.docker.compose.core.DockerHost;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;

class DefaultDockerCompose
implements DockerCompose {
    private final DockerCli cli;
    private final DockerHost hostname;

    DefaultDockerCompose(DockerCli cli, String host) {
        this.cli = cli;
        this.hostname = DockerHost.get(host, () -> cli.run(new DockerCliCommand.Context()));
    }

    @Override
    public void up(LogLevel logLevel) {
        this.up(logLevel, Collections.emptyList());
    }

    @Override
    public void up(LogLevel logLevel, List<String> arguments) {
        this.cli.run(new DockerCliCommand.ComposeUp(logLevel, arguments));
    }

    @Override
    public void down(Duration timeout) {
        this.down(timeout, Collections.emptyList());
    }

    @Override
    public void down(Duration timeout, List<String> arguments) {
        this.cli.run(new DockerCliCommand.ComposeDown(timeout, arguments));
    }

    @Override
    public void start(LogLevel logLevel) {
        this.start(logLevel, Collections.emptyList());
    }

    @Override
    public void start(LogLevel logLevel, List<String> arguments) {
        this.cli.run(new DockerCliCommand.ComposeStart(logLevel, arguments));
    }

    @Override
    public void stop(Duration timeout) {
        this.stop(timeout, Collections.emptyList());
    }

    @Override
    public void stop(Duration timeout, List<String> arguments) {
        this.cli.run(new DockerCliCommand.ComposeStop(timeout, arguments));
    }

    @Override
    public boolean hasDefinedServices() {
        return !this.cli.run(new DockerCliCommand.ComposeConfig()).services().isEmpty();
    }

    @Override
    public List<RunningService> getRunningServices() {
        List<DockerCliComposePsResponse> runningPsResponses = this.runComposePs().stream().filter(this::isRunning).toList();
        if (runningPsResponses.isEmpty()) {
            return Collections.emptyList();
        }
        DockerComposeFile dockerComposeFile = this.cli.getDockerComposeFile();
        ArrayList<DefaultRunningService> result = new ArrayList<DefaultRunningService>();
        Map<String, DockerCliInspectResponse> inspected = this.inspect(runningPsResponses);
        for (DockerCliComposePsResponse psResponse : runningPsResponses) {
            DockerCliInspectResponse inspectResponse = this.inspectContainer(psResponse.id(), inspected);
            Assert.notNull((Object)inspectResponse, () -> "Failed to inspect container '%s'".formatted(psResponse.id()));
            result.add(new DefaultRunningService(this.hostname, dockerComposeFile, psResponse, inspectResponse));
        }
        return Collections.unmodifiableList(result);
    }

    private Map<String, DockerCliInspectResponse> inspect(List<DockerCliComposePsResponse> runningPsResponses) {
        List<String> ids = runningPsResponses.stream().map(DockerCliComposePsResponse::id).toList();
        List<DockerCliInspectResponse> inspectResponses = this.cli.run(new DockerCliCommand.Inspect(ids));
        return inspectResponses.stream().collect(Collectors.toMap(DockerCliInspectResponse::id, Function.identity()));
    }

    private DockerCliInspectResponse inspectContainer(String id, Map<String, DockerCliInspectResponse> inspected) {
        DockerCliInspectResponse inspect = inspected.get(id);
        if (inspect != null) {
            return inspect;
        }
        for (Map.Entry<String, DockerCliInspectResponse> entry : inspected.entrySet()) {
            if (!entry.getKey().startsWith(id)) continue;
            return entry.getValue();
        }
        return null;
    }

    private List<DockerCliComposePsResponse> runComposePs() {
        return this.cli.run(new DockerCliCommand.ComposePs());
    }

    private boolean isRunning(DockerCliComposePsResponse psResponse) {
        return !"exited".equals(psResponse.state());
    }
}

