/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.oracle;

import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.oracle.OracleEnvironment;
import org.springframework.util.StringUtils;

class OracleJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    protected OracleJdbcDockerComposeConnectionDetailsFactory() {
        super("gvenzl/oracle-xe", new String[0]);
    }

    @Override
    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OracleJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class OracleJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final String PARAMETERS_LABEL = "org.springframework.boot.jdbc.parameters";
        private final OracleEnvironment environment;
        private final String jdbcUrl;

        OracleJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new OracleEnvironment(service.env());
            this.jdbcUrl = "jdbc:oracle:thin:@" + service.host() + ":" + service.ports().get(1521) + "/" + this.environment.getDatabase() + this.getParameters(service);
        }

        private String getParameters(RunningService service) {
            String parameters = service.labels().get(PARAMETERS_LABEL);
            return StringUtils.hasLength((String)parameters) ? "?" + parameters : "";
        }

        public String getUsername() {
            return this.environment.getUsername();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

