/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.mariadb;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MariaDbEnvironment {
    private final String username;
    private final String password;
    private final String database;

    MariaDbEnvironment(Map<String, String> env) {
        this.username = this.extractUsername(env);
        this.password = this.extractPassword(env);
        this.database = this.extractDatabase(env);
    }

    private String extractUsername(Map<String, String> env) {
        String user = env.get("MARIADB_USER");
        return user != null ? user : env.getOrDefault("MYSQL_USER", "root");
    }

    private String extractPassword(Map<String, String> env) {
        Assert.state((!env.containsKey("MARIADB_RANDOM_ROOT_PASSWORD") ? 1 : 0) != 0, (String)"MARIADB_RANDOM_ROOT_PASSWORD is not supported");
        Assert.state((!env.containsKey("MYSQL_RANDOM_ROOT_PASSWORD") ? 1 : 0) != 0, (String)"MYSQL_RANDOM_ROOT_PASSWORD is not supported");
        Assert.state((!env.containsKey("MARIADB_ROOT_PASSWORD_HASH") ? 1 : 0) != 0, (String)"MARIADB_ROOT_PASSWORD_HASH is not supported");
        boolean allowEmpty = env.containsKey("MARIADB_ALLOW_EMPTY_PASSWORD") || env.containsKey("MYSQL_ALLOW_EMPTY_PASSWORD");
        String password = env.get("MARIADB_PASSWORD");
        password = password != null ? password : env.get("MYSQL_PASSWORD");
        password = password != null ? password : env.get("MARIADB_ROOT_PASSWORD");
        password = password != null ? password : env.get("MYSQL_ROOT_PASSWORD");
        Assert.state((StringUtils.hasLength((String)password) || allowEmpty ? 1 : 0) != 0, (String)"No MariaDB password found");
        return password != null ? password : "";
    }

    private String extractDatabase(Map<String, String> env) {
        String database = env.get("MARIADB_DATABASE");
        database = database != null ? database : env.get("MYSQL_DATABASE");
        Assert.state((database != null ? 1 : 0) != 0, (String)"No MARIADB_DATABASE defined");
        return database;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

