/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFile;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFiles;
import org.springframework.boot.devtools.restart.server.SourceDirectoryUrlFilter;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;

public class RestartServer {
    private static final Log logger = LogFactory.getLog(RestartServer.class);
    private final SourceDirectoryUrlFilter sourceDirectoryUrlFilter;
    private final ClassLoader classLoader;

    public RestartServer(SourceDirectoryUrlFilter sourceDirectoryUrlFilter) {
        this(sourceDirectoryUrlFilter, Thread.currentThread().getContextClassLoader());
    }

    public RestartServer(SourceDirectoryUrlFilter sourceDirectoryUrlFilter, ClassLoader classLoader) {
        Assert.notNull((Object)sourceDirectoryUrlFilter, (String)"'sourceDirectoryUrlFilter' must not be null");
        Assert.notNull((Object)classLoader, (String)"'classLoader' must not be null");
        this.sourceDirectoryUrlFilter = sourceDirectoryUrlFilter;
        this.classLoader = classLoader;
    }

    public void updateAndRestart(ClassLoaderFiles files) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        Set<URL> classLoaderUrls = this.getClassLoaderUrls();
        for (ClassLoaderFiles.SourceDirectory directory : files.getSourceDirectories()) {
            for (Map.Entry<String, ClassLoaderFile> entry : directory.getFilesEntrySet()) {
                for (URL url : classLoaderUrls) {
                    if (!this.updateFileSystem(url, entry.getKey(), entry.getValue())) continue;
                    urls.add(url);
                }
            }
            urls.addAll(this.getMatchingUrls(classLoaderUrls, directory.getName()));
        }
        this.updateTimeStamp(urls);
        this.restart(urls, files);
    }

    private boolean updateFileSystem(URL url, String name, ClassLoaderFile classLoaderFile) {
        if (!this.isDirectoryUrl(url.toString())) {
            return false;
        }
        try {
            File directory = ResourceUtils.getFile((URL)url);
            File file = new File(directory, name);
            if (file.exists() && file.canWrite()) {
                if (classLoaderFile.getKind() == ClassLoaderFile.Kind.DELETED) {
                    return file.delete();
                }
                byte[] contents = classLoaderFile.getContents();
                Assert.state((contents != null ? 1 : 0) != 0, (String)"'contents' must not be null");
                FileCopyUtils.copy((byte[])contents, (File)file);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isDirectoryUrl(String urlString) {
        return urlString.startsWith("file:") && urlString.endsWith("/");
    }

    private Set<URL> getMatchingUrls(Set<URL> urls, String sourceDirectory) {
        LinkedHashSet<URL> matchingUrls = new LinkedHashSet<URL>();
        for (URL url : urls) {
            if (!this.sourceDirectoryUrlFilter.isMatch(sourceDirectory, url)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("URL " + String.valueOf(url) + " matched against source directory " + sourceDirectory));
            }
            matchingUrls.add(url);
        }
        return matchingUrls;
    }

    private Set<URL> getClassLoaderUrls() {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (ClassLoader classLoader = this.classLoader; classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            Collections.addAll(urls, urlClassLoader.getURLs());
        }
        return urls;
    }

    private void updateTimeStamp(Iterable<URL> urls) {
        for (URL url : urls) {
            this.updateTimeStamp(url);
        }
    }

    private void updateTimeStamp(URL url) {
        try {
            URL actualUrl = ResourceUtils.extractJarFileURL((URL)url);
            File file = ResourceUtils.getFile((URL)actualUrl, (String)"Jar URL");
            file.setLastModified(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void restart(Set<URL> urls, ClassLoaderFiles files) {
        Restarter restarter = Restarter.getInstance();
        restarter.addUrls(urls);
        restarter.addClassLoaderFiles(files);
        restarter.restart();
    }
}

