/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.net.URL;
import org.springframework.boot.devtools.restart.ChangeableUrls;
import org.springframework.boot.devtools.restart.RestartInitializer;
import org.springframework.boot.devtools.system.DevToolsEnablementDeducer;

public class DefaultRestartInitializer
implements RestartInitializer {
    @Override
    public URL[] getInitialUrls(Thread thread) {
        if (!this.isMain(thread)) {
            return null;
        }
        if (!DevToolsEnablementDeducer.shouldEnable(thread)) {
            return null;
        }
        return this.getUrls(thread);
    }

    protected boolean isMain(Thread thread) {
        return this.isMainThread(thread) && this.isDevelopmentClassLoader(thread.getContextClassLoader());
    }

    protected boolean isMainThread(Thread thread) {
        return thread.getName().equals("main");
    }

    protected boolean isDevelopmentClassLoader(ClassLoader classLoader) {
        return classLoader.getClass().getName().contains("AppClassLoader");
    }

    protected URL[] getUrls(Thread thread) {
        return ChangeableUrls.fromClassLoader(thread.getContextClassLoader()).toArray();
    }
}

