/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.devtools.autoconfigure.DevToolsProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
@Configuration
class RemoteDevtoolsSecurityConfiguration {
    RemoteDevtoolsSecurityConfiguration() {
    }

    @Order(value=0x7FFFFFF9)
    @Configuration
    static class SecurityConfiguration
    extends WebSecurityConfigurerAdapter {
        private final String url;

        SecurityConfiguration(DevToolsProperties devToolsProperties, ServerProperties serverProperties) {
            ServerProperties.Servlet servlet = serverProperties.getServlet();
            String servletContextPath = servlet.getContextPath() != null ? servlet.getContextPath() : "";
            this.url = servletContextPath + devToolsProperties.getRemote().getContextPath() + "/restart";
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher((RequestMatcher)new AntPathRequestMatcher(this.url)).authorizeRequests().anyRequest()).anonymous().and()).csrf().disable();
        }
    }
}

