/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.task;

import java.util.List;
import java.util.concurrent.Executor;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.task.SimpleAsyncTaskExecutorBuilder;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.boot.thread.Threading;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.CompositeTaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

class TaskExecutorConfigurations {
    TaskExecutorConfigurations() {
    }

    private static @Nullable TaskDecorator getTaskDecorator(ObjectProvider<TaskDecorator> taskDecorator) {
        List taskDecorators = taskDecorator.orderedStream().toList();
        if (taskDecorators.size() == 1) {
            return (TaskDecorator)taskDecorators.get(0);
        }
        return !taskDecorators.isEmpty() ? new CompositeTaskDecorator(taskDecorators) : null;
    }

    static class OnExecutorCondition
    extends AnyNestedCondition {
        OnExecutorCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.task.execution.mode"}, havingValue="force")
        private static final class ModelCondition {
            private ModelCondition() {
            }
        }

        @ConditionalOnMissingBean(value={Executor.class})
        private static final class ExecutorBeanCondition {
            private ExecutorBeanCondition() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class BootstrapExecutorConfiguration {
        BootstrapExecutorConfiguration() {
        }

        @Bean
        static BeanFactoryPostProcessor bootstrapExecutorAliasPostProcessor() {
            return beanFactory -> {
                boolean hasBootstrapExecutor = beanFactory.containsBean("bootstrapExecutor");
                boolean hasApplicationTaskExecutor = beanFactory.containsBean("applicationTaskExecutor");
                if (!hasBootstrapExecutor && hasApplicationTaskExecutor) {
                    beanFactory.registerAlias("applicationTaskExecutor", "bootstrapExecutor");
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={AsyncConfigurer.class})
    static class AsyncConfigurerConfiguration {
        AsyncConfigurerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        AsyncConfigurer applicationTaskExecutorAsyncConfigurer(final BeanFactory beanFactory) {
            return new AsyncConfigurer(){
                final /* synthetic */ AsyncConfigurerConfiguration this$0;
                {
                    this.this$0 = this$0;
                }

                public Executor getAsyncExecutor() {
                    return (Executor)beanFactory.getBean("applicationTaskExecutor", Executor.class);
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SimpleAsyncTaskExecutorBuilderConfiguration {
        private final TaskExecutionProperties properties;
        private final ObjectProvider<SimpleAsyncTaskExecutorCustomizer> taskExecutorCustomizers;
        private final ObjectProvider<TaskDecorator> taskDecorator;

        SimpleAsyncTaskExecutorBuilderConfiguration(TaskExecutionProperties properties, ObjectProvider<SimpleAsyncTaskExecutorCustomizer> taskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            this.properties = properties;
            this.taskExecutorCustomizers = taskExecutorCustomizers;
            this.taskDecorator = taskDecorator;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        SimpleAsyncTaskExecutorBuilder simpleAsyncTaskExecutorBuilder() {
            return this.builder();
        }

        @Bean(name={"simpleAsyncTaskExecutorBuilder"})
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskExecutorBuilder simpleAsyncTaskExecutorBuilderVirtualThreads() {
            return this.builder().virtualThreads(Boolean.valueOf(true));
        }

        private SimpleAsyncTaskExecutorBuilder builder() {
            SimpleAsyncTaskExecutorBuilder builder = new SimpleAsyncTaskExecutorBuilder();
            builder = builder.threadNamePrefix(this.properties.getThreadNamePrefix());
            builder = builder.customizers(this.taskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator(TaskExecutorConfigurations.getTaskDecorator(this.taskDecorator));
            TaskExecutionProperties.Simple simple = this.properties.getSimple();
            builder = builder.rejectTasksWhenLimitReached(simple.isRejectTasksWhenLimitReached());
            builder = builder.concurrencyLimit(simple.getConcurrencyLimit());
            TaskExecutionProperties.Shutdown shutdown = this.properties.getShutdown();
            if (shutdown.isAwaitTermination()) {
                builder = builder.taskTerminationTimeout(shutdown.getAwaitTerminationPeriod());
            }
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ThreadPoolTaskExecutorBuilderConfiguration {
        ThreadPoolTaskExecutorBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ThreadPoolTaskExecutorBuilder threadPoolTaskExecutorBuilder(TaskExecutionProperties properties, ObjectProvider<ThreadPoolTaskExecutorCustomizer> threadPoolTaskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            TaskExecutionProperties.Pool pool = properties.getPool();
            ThreadPoolTaskExecutorBuilder builder = new ThreadPoolTaskExecutorBuilder();
            builder = builder.queueCapacity(pool.getQueueCapacity());
            builder = builder.corePoolSize(pool.getCoreSize());
            builder = builder.maxPoolSize(pool.getMaxSize());
            builder = builder.allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout());
            builder = builder.keepAlive(pool.getKeepAlive());
            builder = builder.acceptTasksAfterContextClose(pool.getShutdown().isAcceptTasksAfterContextClose());
            TaskExecutionProperties.Shutdown shutdown = properties.getShutdown();
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.customizers(threadPoolTaskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator(TaskExecutorConfigurations.getTaskDecorator(taskDecorator));
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnExecutorCondition.class})
    @Import(value={AsyncConfigurerConfiguration.class})
    static class TaskExecutorConfiguration {
        TaskExecutorConfiguration() {
        }

        @Bean(value={"applicationTaskExecutor"})
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskExecutor applicationTaskExecutorVirtualThreads(SimpleAsyncTaskExecutorBuilder builder) {
            return builder.build();
        }

        @Bean(value={"applicationTaskExecutor"})
        @Lazy
        @ConditionalOnThreading(value=Threading.PLATFORM)
        ThreadPoolTaskExecutor applicationTaskExecutor(ThreadPoolTaskExecutorBuilder threadPoolTaskExecutorBuilder) {
            return threadPoolTaskExecutorBuilder.build();
        }
    }
}

