/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

abstract class FilteringSpringBootCondition
extends SpringBootCondition
implements AutoConfigurationImportFilter,
BeanFactoryAware,
BeanClassLoaderAware {
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;

    FilteringSpringBootCondition() {
    }

    @Override
    public boolean[] match(@Nullable String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionEvaluationReport report = ConditionEvaluationReport.find(this.beanFactory);
        @Nullable ConditionOutcome[] outcomes = this.getOutcomes(autoConfigurationClasses, autoConfigurationMetadata);
        boolean[] match = new boolean[outcomes.length];
        for (int i = 0; i < outcomes.length; ++i) {
            boolean bl = match[i] = outcomes[i] == null || outcomes[i].isMatch();
            if (match[i] || outcomes[i] == null) continue;
            String autoConfigurationClass = autoConfigurationClasses[i];
            Assert.state((autoConfigurationClass != null ? 1 : 0) != 0, (String)"'autoConfigurationClass' must not be null");
            this.logOutcome(autoConfigurationClass, outcomes[i]);
            if (report == null) continue;
            report.recordConditionEvaluation(autoConfigurationClass, this, outcomes[i]);
        }
        return match;
    }

    protected abstract @Nullable ConditionOutcome[] getOutcomes(@Nullable String[] var1, AutoConfigurationMetadata var2);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected final ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected final List<String> filter(@Nullable Collection<String> classNames, ClassNameFilter classNameFilter, @Nullable ClassLoader classLoader) {
        if (CollectionUtils.isEmpty(classNames)) {
            return Collections.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>(classNames.size());
        for (String candidate : classNames) {
            if (!classNameFilter.matches(candidate, classLoader)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    protected static Class<?> resolve(String className, @Nullable ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            return Class.forName(className, false, classLoader);
        }
        return Class.forName(className);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum ClassNameFilter {
        PRESENT{

            @Override
            public boolean matches(String className, @Nullable ClassLoader classLoader) {
                return ClassNameFilter.isPresent(className, classLoader);
            }
        }
        ,
        MISSING{

            @Override
            public boolean matches(String className, @Nullable ClassLoader classLoader) {
                return !ClassNameFilter.isPresent(className, classLoader);
            }
        };


        abstract boolean matches(String var1, @Nullable ClassLoader var2);

        private static boolean isPresent(String className, @Nullable ClassLoader classLoader) {
            if (classLoader == null) {
                classLoader = ClassUtils.getDefaultClassLoader();
            }
            try {
                FilteringSpringBootCondition.resolve(className, classLoader);
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }
}

