/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql;

import java.time.Duration;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.graphql")
public class GraphQlProperties {
    private final Http http = new Http();
    private final Graphiql graphiql = new Graphiql();
    private final Rsocket rsocket = new Rsocket();
    private final Schema schema = new Schema();
    private final DeprecatedSse sse = new DeprecatedSse(this.http.getSse());
    private final Websocket websocket = new Websocket();

    public Http getHttp() {
        return this.http;
    }

    public Graphiql getGraphiql() {
        return this.graphiql;
    }

    @DeprecatedConfigurationProperty(replacement="spring.graphql.http.path", since="3.5.0")
    @Deprecated(since="3.5.0", forRemoval=true)
    public String getPath() {
        return this.getHttp().getPath();
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    public void setPath(String path) {
        this.getHttp().setPath(path);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Websocket getWebsocket() {
        return this.websocket;
    }

    public Rsocket getRsocket() {
        return this.rsocket;
    }

    public DeprecatedSse getSse() {
        return this.sse;
    }

    public static class Http {
        private String path = "/graphql";
        private final Sse sse = new Sse();

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Sse getSse() {
            return this.sse;
        }
    }

    public static class Graphiql {
        private String path = "/graphiql";
        private boolean enabled = false;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Rsocket {
        private String mapping;

        public String getMapping() {
            return this.mapping;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }
    }

    public static class Schema {
        private String[] locations = new String[]{"classpath:graphql/**/"};
        private String[] fileExtensions = new String[]{".graphqls", ".gqls"};
        private Resource[] additionalFiles = new Resource[0];
        private final Inspection inspection = new Inspection();
        private final Introspection introspection = new Introspection();
        private final Printer printer = new Printer();

        public String[] getLocations() {
            return this.locations;
        }

        public void setLocations(String[] locations) {
            this.locations = this.appendSlashIfNecessary(locations);
        }

        public String[] getFileExtensions() {
            return this.fileExtensions;
        }

        public void setFileExtensions(String[] fileExtensions) {
            this.fileExtensions = fileExtensions;
        }

        public Resource[] getAdditionalFiles() {
            return this.additionalFiles;
        }

        public void setAdditionalFiles(Resource[] additionalFiles) {
            this.additionalFiles = additionalFiles;
        }

        private String[] appendSlashIfNecessary(String[] locations) {
            return (String[])Arrays.stream(locations).map(location -> location.endsWith("/") ? location : location + "/").toArray(String[]::new);
        }

        public Inspection getInspection() {
            return this.inspection;
        }

        public Introspection getIntrospection() {
            return this.introspection;
        }

        public Printer getPrinter() {
            return this.printer;
        }

        public static class Inspection {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class Introspection {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class Printer {
            private boolean enabled = false;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    @Deprecated(since="3.5.1", forRemoval=true)
    public static final class DeprecatedSse {
        private final Sse sse;

        private DeprecatedSse(Sse sse) {
            this.sse = sse;
        }

        @DeprecatedConfigurationProperty(replacement="spring.graphql.http.sse.timeout", since="3.5.0")
        @Deprecated(since="3.5.0", forRemoval=true)
        public Duration getTimeout() {
            return this.sse.getTimeout();
        }

        @Deprecated(since="3.5.0", forRemoval=true)
        public void setTimeout(Duration timeout) {
            this.sse.setTimeout(timeout);
        }
    }

    public static class Sse {
        private Duration keepAlive;
        private Duration timeout;

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }
    }

    public static class Websocket {
        private String path;
        private Duration connectionInitTimeout = Duration.ofSeconds(60L);
        private Duration keepAlive;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Duration getConnectionInitTimeout() {
            return this.connectionInitTimeout;
        }

        public void setConnectionInitTimeout(Duration connectionInitTimeout) {
            this.connectionInitTimeout = connectionInitTimeout;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }
    }
}

