/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.reactive.ReactiveResponseConsumer;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.reactor.netty.ReactorNettyConfigurations;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.HttpComponentsClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.JdkClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.JettyClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ReactorClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ReactorNettyHttpClientMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.reactive.JettyResourceFactory;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import reactor.netty.http.client.HttpClient;

class ClientHttpConnectorFactoryConfiguration {
    ClientHttpConnectorFactoryConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={java.net.http.HttpClient.class})
    @ConditionalOnMissingBean(value={ClientHttpConnectorFactory.class})
    static class JdkClient {
        JdkClient() {
        }

        @Bean
        JdkClientHttpConnectorFactory jdkClientHttpConnectorFactory() {
            return new JdkClientHttpConnectorFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpAsyncClients.class, AsyncRequestProducer.class, ReactiveResponseConsumer.class})
    @ConditionalOnMissingBean(value={ClientHttpConnectorFactory.class})
    static class HttpClient5 {
        HttpClient5() {
        }

        @Bean
        HttpComponentsClientHttpConnectorFactory httpComponentsClientHttpConnectorFactory() {
            return new HttpComponentsClientHttpConnectorFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveRequest.class})
    @ConditionalOnMissingBean(value={ClientHttpConnectorFactory.class})
    static class JettyClient {
        JettyClient() {
        }

        @Bean
        @ConditionalOnMissingBean
        JettyResourceFactory jettyClientResourceFactory() {
            return new JettyResourceFactory();
        }

        @Bean
        JettyClientHttpConnectorFactory jettyClientHttpConnectorFactory(JettyResourceFactory jettyResourceFactory) {
            return new JettyClientHttpConnectorFactory(jettyResourceFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnMissingBean(value={ClientHttpConnectorFactory.class})
    @Import(value={ReactorNettyConfigurations.ReactorResourceFactoryConfiguration.class})
    static class ReactorNetty {
        ReactorNetty() {
        }

        @Bean
        ReactorClientHttpConnectorFactory reactorClientHttpConnectorFactory(ReactorResourceFactory reactorResourceFactory, ObjectProvider<ReactorNettyHttpClientMapper> mapperProvider) {
            return new ReactorClientHttpConnectorFactory(reactorResourceFactory, () -> mapperProvider.orderedStream());
        }
    }
}

