/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.stream.Environment;
import com.rabbitmq.stream.EnvironmentBuilder;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.EnvironmentBuilderCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitStreamTemplateConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.rabbit.stream.config.StreamRabbitListenerContainerFactory;
import org.springframework.rabbit.stream.listener.ConsumerCustomizer;
import org.springframework.rabbit.stream.listener.StreamListenerContainer;
import org.springframework.rabbit.stream.producer.ProducerCustomizer;
import org.springframework.rabbit.stream.producer.RabbitStreamOperations;
import org.springframework.rabbit.stream.producer.RabbitStreamTemplate;
import org.springframework.rabbit.stream.support.converter.StreamMessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={StreamRabbitListenerContainerFactory.class})
class RabbitStreamConfiguration {
    RabbitStreamConfiguration() {
    }

    @Bean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnMissingBean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnProperty(prefix="spring.rabbitmq.listener", name={"type"}, havingValue="stream")
    StreamRabbitListenerContainerFactory streamRabbitListenerContainerFactory(Environment rabbitStreamEnvironment, RabbitProperties properties, ObjectProvider<ConsumerCustomizer> consumerCustomizer, ObjectProvider<ContainerCustomizer<StreamListenerContainer>> containerCustomizer) {
        StreamRabbitListenerContainerFactory factory = new StreamRabbitListenerContainerFactory(rabbitStreamEnvironment);
        factory.setNativeListener(properties.getListener().getStream().isNativeListener());
        consumerCustomizer.ifUnique(arg_0 -> ((StreamRabbitListenerContainerFactory)factory).setConsumerCustomizer(arg_0));
        containerCustomizer.ifUnique(arg_0 -> ((StreamRabbitListenerContainerFactory)factory).setContainerCustomizer(arg_0));
        return factory;
    }

    @Bean(name={"rabbitStreamEnvironment"})
    @ConditionalOnMissingBean(name={"rabbitStreamEnvironment"})
    Environment rabbitStreamEnvironment(RabbitProperties properties, ObjectProvider<EnvironmentBuilderCustomizer> customizers) {
        EnvironmentBuilder builder = RabbitStreamConfiguration.configure(Environment.builder(), properties);
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    RabbitStreamTemplateConfigurer rabbitStreamTemplateConfigurer(RabbitProperties properties, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<StreamMessageConverter> streamMessageConverter, ObjectProvider<ProducerCustomizer> producerCustomizer) {
        RabbitStreamTemplateConfigurer configurer = new RabbitStreamTemplateConfigurer();
        configurer.setMessageConverter((MessageConverter)messageConverter.getIfUnique());
        configurer.setStreamMessageConverter((StreamMessageConverter)streamMessageConverter.getIfUnique());
        configurer.setProducerCustomizer((ProducerCustomizer)producerCustomizer.getIfUnique());
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(value={RabbitStreamOperations.class})
    @ConditionalOnProperty(prefix="spring.rabbitmq.stream", name={"name"})
    RabbitStreamTemplate rabbitStreamTemplate(Environment rabbitStreamEnvironment, RabbitProperties properties, RabbitStreamTemplateConfigurer configurer) {
        RabbitStreamTemplate template = new RabbitStreamTemplate(rabbitStreamEnvironment, properties.getStream().getName());
        configurer.configure(template);
        return template;
    }

    static EnvironmentBuilder configure(EnvironmentBuilder builder, RabbitProperties properties) {
        builder.lazyInitialization(true);
        RabbitProperties.Stream stream = properties.getStream();
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)stream.getHost()).to(arg_0 -> ((EnvironmentBuilder)builder).host(arg_0));
        map.from((Object)stream.getPort()).to(arg_0 -> ((EnvironmentBuilder)builder).port(arg_0));
        map.from((Object)stream.getUsername()).as(RabbitStreamConfiguration.withFallback(properties::getUsername)).whenNonNull().to(arg_0 -> ((EnvironmentBuilder)builder).username(arg_0));
        map.from((Object)stream.getPassword()).as(RabbitStreamConfiguration.withFallback(properties::getPassword)).whenNonNull().to(arg_0 -> ((EnvironmentBuilder)builder).password(arg_0));
        return builder;
    }

    private static Function<String, String> withFallback(Supplier<String> fallback) {
        return value -> value != null ? value : (String)fallback.get();
    }
}

