/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.quartz;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.boot.jdbc.AbstractDataSourceInitializer;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.Assert;

public class QuartzDataSourceInitializer
extends AbstractDataSourceInitializer {
    private final QuartzProperties properties;

    public QuartzDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader, QuartzProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull((Object)properties, (String)"QuartzProperties must not be null");
        this.properties = properties;
    }

    protected void customize(ResourceDatabasePopulator populator) {
        populator.setCommentPrefixes(this.properties.getJdbc().getCommentPrefix().toArray(new String[0]));
    }

    protected DataSourceInitializationMode getMode() {
        return this.properties.getJdbc().getInitializeSchema();
    }

    protected String getSchemaLocation() {
        return this.properties.getJdbc().getSchema();
    }

    protected String getDatabaseName() {
        String databaseName = super.getDatabaseName();
        if ("db2".equals(databaseName)) {
            return "db2_v95";
        }
        if ("mysql".equals(databaseName) || "mariadb".equals(databaseName)) {
            return "mysql_innodb";
        }
        if ("postgresql".equals(databaseName)) {
            return "postgres";
        }
        if ("sqlserver".equals(databaseName)) {
            return "sqlServer";
        }
        return databaseName;
    }
}

