/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import java.net.URI;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceInitializationMode;

@ConfigurationProperties(prefix="spring.integration")
public class IntegrationProperties {
    private final Jdbc jdbc = new Jdbc();
    private final RSocket rsocket = new RSocket();

    public Jdbc getJdbc() {
        return this.jdbc;
    }

    public RSocket getRsocket() {
        return this.rsocket;
    }

    public static class RSocket {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Server {
            boolean messageMappingEnabled;

            public boolean isMessageMappingEnabled() {
                return this.messageMappingEnabled;
            }

            public void setMessageMappingEnabled(boolean messageMappingEnabled) {
                this.messageMappingEnabled = messageMappingEnabled;
            }
        }

        public static class Client {
            private String host;
            private Integer port;
            private URI uri;

            public void setHost(String host) {
                this.host = host;
            }

            public String getHost() {
                return this.host;
            }

            public void setPort(Integer port) {
                this.port = port;
            }

            public Integer getPort() {
                return this.port;
            }

            public void setUri(URI uri) {
                this.uri = uri;
            }

            public URI getUri() {
                return this.uri;
            }
        }
    }

    public static class Jdbc {
        private static final String DEFAULT_SCHEMA_LOCATION = "classpath:org/springframework/integration/jdbc/schema-@@platform@@.sql";
        private String schema = "classpath:org/springframework/integration/jdbc/schema-@@platform@@.sql";
        private DataSourceInitializationMode initializeSchema = DataSourceInitializationMode.EMBEDDED;

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public DataSourceInitializationMode getInitializeSchema() {
            return this.initializeSchema;
        }

        public void setInitializeSchema(DataSourceInitializationMode initializeSchema) {
            this.initializeSchema = initializeSchema;
        }
    }
}

