/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.DefaultCollector;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class MustacheEnvironmentCollector
extends DefaultCollector
implements EnvironmentAware {
    private ConfigurableEnvironment environment;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public Mustache.VariableFetcher createFetcher(Object ctx, String name) {
        Mustache.VariableFetcher nativeFetcher = super.createFetcher(ctx, name);
        if (nativeFetcher != null) {
            return new PropertyVariableFetcher(nativeFetcher);
        }
        if (this.environment.containsProperty(name)) {
            return new PropertyVariableFetcher();
        }
        return null;
    }

    private class PropertyVariableFetcher
    implements Mustache.VariableFetcher {
        private final Mustache.VariableFetcher nativeFetcher;

        PropertyVariableFetcher() {
            this.nativeFetcher = null;
        }

        PropertyVariableFetcher(Mustache.VariableFetcher delegate) {
            this.nativeFetcher = delegate;
        }

        public Object get(Object ctx, String name) {
            Object result = this.getFromNativeFetcher(ctx, name);
            result = result != null ? result : this.getFromEnvironment(name);
            return result != null ? result : Template.NO_FETCHER_FOUND;
        }

        private Object getFromNativeFetcher(Object ctx, String name) {
            try {
                Object result = this.nativeFetcher != null ? this.nativeFetcher.get(ctx, name) : null;
                return result != Template.NO_FETCHER_FOUND ? result : null;
            }
            catch (Exception ex) {
                return null;
            }
        }

        private Object getFromEnvironment(String name) {
            return MustacheEnvironmentCollector.this.environment.getProperty(name);
        }
    }
}

