/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ldap;

import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ldap.LdapProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@ConditionalOnClass(value={ContextSource.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapAutoConfiguration {
    private final LdapProperties properties;
    private final Environment environment;

    public LdapAutoConfiguration(LdapProperties properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean
    public LdapContextSource ldapContextSource() {
        LdapContextSource source = new LdapContextSource();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)this.properties.getUsername()).to(arg_0 -> ((LdapContextSource)source).setUserDn(arg_0));
        propertyMapper.from((Object)this.properties.getPassword()).to(arg_0 -> ((LdapContextSource)source).setPassword(arg_0));
        propertyMapper.from((Object)this.properties.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)source).setAnonymousReadOnly(arg_0));
        propertyMapper.from((Object)this.properties.getBase()).to(arg_0 -> ((LdapContextSource)source).setBase(arg_0));
        propertyMapper.from((Object)this.properties.determineUrls(this.environment)).to(arg_0 -> ((LdapContextSource)source).setUrls(arg_0));
        propertyMapper.from(this.properties.getBaseEnvironment()).to(baseEnvironment -> source.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        return source;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapOperations.class})
    public LdapTemplate ldapTemplate(ContextSource contextSource) {
        return new LdapTemplate(contextSource);
    }
}

