/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.http.GsonHttpMessageConvertersConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpProperties;
import org.springframework.boot.autoconfigure.http.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.autoconfigure.http.JsonbHttpMessageConvertersConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jsonb.JsonbAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;

@Configuration
@ConditionalOnClass(value={HttpMessageConverter.class})
@AutoConfigureAfter(value={GsonAutoConfiguration.class, JacksonAutoConfiguration.class, JsonbAutoConfiguration.class})
@Import(value={JacksonHttpMessageConvertersConfiguration.class, GsonHttpMessageConvertersConfiguration.class, JsonbHttpMessageConvertersConfiguration.class})
public class HttpMessageConvertersAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";
    private final List<HttpMessageConverter<?>> converters;

    public HttpMessageConvertersAutoConfiguration(ObjectProvider<HttpMessageConverter<?>> convertersProvider) {
        this.converters = convertersProvider.orderedStream().collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters() {
        return new HttpMessageConverters(this.converters);
    }

    @Configuration
    @ConditionalOnClass(value={StringHttpMessageConverter.class})
    @EnableConfigurationProperties(value={HttpProperties.class})
    protected static class StringHttpMessageConverterConfiguration {
        private final HttpProperties.Encoding properties;

        protected StringHttpMessageConverterConfiguration(HttpProperties httpProperties) {
            this.properties = httpProperties.getEncoding();
        }

        @Bean
        @ConditionalOnMissingBean
        public StringHttpMessageConverter stringHttpMessageConverter() {
            StringHttpMessageConverter converter = new StringHttpMessageConverter(this.properties.getCharset());
            converter.setWriteAcceptCharset(false);
            return converter;
        }
    }
}

