/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.config.IntegrationComponentScanRegistrar;

class IntegrationAutoConfigurationScanRegistrar
extends IntegrationComponentScanRegistrar
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    IntegrationAutoConfigurationScanRegistrar() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        super.registerBeanDefinitions((AnnotationMetadata)new IntegrationComponentScanConfigurationMetaData(this.beanFactory), registry);
    }

    @IntegrationComponentScan
    private static class IntegrationComponentScanConfiguration {
        private IntegrationComponentScanConfiguration() {
        }
    }

    private static class IntegrationComponentScanConfigurationMetaData
    extends StandardAnnotationMetadata {
        private final BeanFactory beanFactory;

        IntegrationComponentScanConfigurationMetaData(BeanFactory beanFactory) {
            super(IntegrationComponentScanConfiguration.class, true);
            this.beanFactory = beanFactory;
        }

        public Map<String, Object> getAnnotationAttributes(String annotationName) {
            LinkedHashMap<String, String[]> attributes = super.getAnnotationAttributes(annotationName);
            if (IntegrationComponentScan.class.getName().equals(annotationName) && AutoConfigurationPackages.has(this.beanFactory)) {
                List<String> packages = AutoConfigurationPackages.get(this.beanFactory);
                attributes = new LinkedHashMap<String, String[]>(attributes);
                attributes.put("value", packages.toArray(new String[packages.size()]));
            }
            return attributes;
        }
    }
}

