/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.neo4j;

import java.util.List;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.template.Neo4jOperations;

@Configuration
@ConditionalOnClass(value={Neo4jSession.class, Neo4jOperations.class})
@ConditionalOnMissingBean(value={Neo4jOperations.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
public class Neo4jDataAutoConfiguration {
    private final Neo4jProperties properties;

    public Neo4jDataAutoConfiguration(Neo4jProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public org.neo4j.ogm.config.Configuration configuration() {
        return this.properties.createConfiguration();
    }

    @Configuration
    static class SpringBootNeo4jConfiguration
    extends Neo4jConfiguration {
        private final ApplicationContext applicationContext;
        private final org.neo4j.ogm.config.Configuration configuration;

        SpringBootNeo4jConfiguration(ApplicationContext applicationContext, org.neo4j.ogm.config.Configuration configuration) {
            this.applicationContext = applicationContext;
            this.configuration = configuration;
        }

        public SessionFactory getSessionFactory() {
            return new SessionFactory(this.configuration, this.getPackagesToScan());
        }

        private String[] getPackagesToScan() {
            List<String> packages = EntityScanPackages.get((BeanFactory)this.applicationContext).getPackageNames();
            if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)this.applicationContext)) {
                packages = AutoConfigurationPackages.get((BeanFactory)this.applicationContext);
            }
            return packages.toArray(new String[packages.size()]);
        }

        @Bean
        @Scope(scopeName="${spring.data.neo4j.session.scope:singleton}", proxyMode=ScopedProxyMode.TARGET_CLASS)
        public Session getSession() throws Exception {
            return super.getSession();
        }
    }
}

